/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.cave;

import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class CavePlantFeature
extends AbstractCaveFeature<Config> {
    public CavePlantFeature(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public boolean generate(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, Config config) {
        for (int i = 0; i < config.tries; ++i) {
            BlockState plant = config.plant;
            BlockPos placePos = pos.m_7918_(rand.m_188503_(config.radius * 2) - config.radius, rand.m_188503_(config.radius * 2) - config.radius, rand.m_188503_(config.radius * 2) - config.radius);
            if (!world.m_46859_(placePos) || !plant.m_60710_((LevelReader)world, placePos) || world.m_46861_(placePos)) continue;
            this.m_5974_((LevelWriter)world, placePos, plant);
        }
        return true;
    }

    @Override
    public boolean isValidPos(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, Config config) {
        return world.m_46859_(pos);
    }

    @Override
    public int getMaxHeight(Config config) {
        return config.radius;
    }

    public static class Config
    implements FeatureConfiguration {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("plant").forGetter(config -> config.plant), (App)Codec.INT.fieldOf("tries").forGetter(config -> config.tries), (App)Codec.INT.fieldOf("radius").forGetter(config -> config.radius)).apply((Applicative)instance, Config::new));
        public final BlockState plant;
        public final int tries;
        public final int radius;

        public Config(BlockState plant, int tries, int radius) {
            this.plant = plant;
            this.tries = tries;
            this.radius = radius;
        }
    }
}

