/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss.summons;

import com.legacy.blue_skies.entities.hostile.boss.SummonerEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDamageSources;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class StrangeLightningEntity
extends Entity {
    private int lightningState;
    public long boltVertex;
    private int boltLivingTime;
    private final boolean effectOnly;
    @Nullable
    private ServerPlayer caster;

    public StrangeLightningEntity(Level level) {
        this(SkiesEntityTypes.STRANGE_LIGHTNING, level);
    }

    public StrangeLightningEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
        this.lightningState = 2;
        this.boltVertex = this.f_19796_.m_188505_();
        this.boltLivingTime = this.f_19796_.m_188503_(3) + 1;
        this.effectOnly = false;
        Difficulty difficulty = level.m_46791_();
        if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
            this.igniteBlocks(4);
        }
    }

    public StrangeLightningEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(world);
    }

    public SoundSource m_5720_() {
        return SoundSource.WEATHER;
    }

    public void setCaster(@Nullable ServerPlayer p_204809_1_) {
        this.caster = p_204809_1_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.lightningState == 2) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 5.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f);
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12089_, SoundSource.WEATHER, 2.0f, 0.5f + this.f_19796_.m_188501_() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.m_146870_();
            } else if (this.lightningState < -this.f_19796_.m_188503_(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.f_19796_.m_188505_();
                this.igniteBlocks(0);
            }
        }
        if (this.lightningState >= 0 && !this.effectOnly) {
            List list = this.m_9236_().m_45933_((Entity)this, new AABB(this.m_20185_() - 3.0, this.m_20186_() - 3.0, this.m_20189_() - 3.0, this.m_20185_() + 3.0, this.m_20186_() + 6.0 + 3.0, this.m_20189_() + 3.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity instanceof SummonerEntity || entity instanceof ArtificialGolemEntity) continue;
                entity.m_6469_(SkiesDamageSources.get(entity.m_9236_()).strangeLightning(this, null), 2.0f);
            }
        }
    }

    private void igniteBlocks(int extraIgnitions) {
        if (!this.effectOnly && !this.m_9236_().f_46443_) {
            BlockState blockstate = SkiesBlocks.blue_fire.m_49966_();
            BlockPos blockpos = this.m_20183_();
            if (this.m_9236_().m_8055_(blockpos).m_60795_() && blockstate.m_60710_((LevelReader)this.m_9236_(), blockpos)) {
                this.m_9236_().m_46597_(blockpos, blockstate);
            }
            for (int i = 0; i < extraIgnitions; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1);
                if (!this.m_9236_().m_8055_(blockpos1).m_60795_() || !blockstate.m_60710_((LevelReader)this.m_9236_(), blockpos1)) continue;
                this.m_9236_().m_46597_(blockpos1, blockstate);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = 64.0 * StrangeLightningEntity.m_20150_();
        return distance < d0 * d0;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

