/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.toast;

import com.legacy.blue_skies.registries.SkiesItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SkiesToast
implements Toast {
    private final ResourceLocation backgroundTexture;
    private final Component desc;
    private final Component name;
    private final Item displayItem;
    private final ChatFormatting defaultColor;
    private boolean hasPlayedSound;
    @Nullable
    private final SoundEvent sound;

    public SkiesToast(Component nameIn, Component description, @Nullable SoundEvent soundIn, ResourceLocation backgroundTextureIn, Item itemIn, ChatFormatting defaultColorIn) {
        this.desc = description;
        this.name = nameIn;
        this.sound = soundIn;
        this.backgroundTexture = backgroundTextureIn;
        this.displayItem = itemIn;
        this.defaultColor = defaultColorIn;
    }

    public void beginDisplaying() {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)this);
    }

    public Toast.Visibility m_7172_(GuiGraphics graphics, ToastComponent toast, long toastTime) {
        int color;
        graphics.m_280218_(this.backgroundTexture, 0, 0, 0, 0, this.m_7828_(), this.m_94899_());
        List list = toast.m_94929_().f_91062_.m_92923_((FormattedText)this.desc, 125);
        int n = color = this.desc.m_7383_() != null && this.desc.m_7383_().m_131135_() != null ? this.desc.m_7383_().m_131135_().m_131265_() : this.defaultColor.m_126665_().intValue();
        if (list.size() == 1) {
            graphics.m_280430_(toast.m_94929_().f_91062_, this.name, 30, 7, color | 0xFF000000);
            graphics.m_280648_(toast.m_94929_().f_91062_, (FormattedCharSequence)list.get(0), 30, 18, -1);
        } else if (toastTime < 1500L) {
            int k = Mth.m_14143_((float)(Mth.m_14036_((float)((float)(1500L - toastTime) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
            graphics.m_280430_(toast.m_94929_().f_91062_, this.name, 30, 11, color | k);
        } else {
            int i1 = Mth.m_14143_((float)(Mth.m_14036_((float)((float)(toastTime - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
            int l = this.m_94899_() / 2 - list.size() * 9 / 2;
            for (FormattedCharSequence ireorderingprocessor : list) {
                graphics.m_280648_(toast.m_94929_().f_91062_, ireorderingprocessor, 30, l, 0xFFFFFF | i1);
                l += 9;
            }
        }
        if (!this.hasPlayedSound && toastTime > 0L) {
            this.hasPlayedSound = true;
            if (this.sound != null) {
                toast.m_94929_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)this.sound, (float)1.0f, (float)1.0f));
            }
        }
        graphics.m_280480_(new ItemStack((ItemLike)this.displayItem), 8, 8);
        return toastTime >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public static class Builder {
        private ResourceLocation backgroundTexture = Toast.f_94893_;
        private Component desc = Component.m_237119_();
        private Component name = Component.m_237119_();
        private Item displayItem = SkiesItems.blue_journal;
        private SoundEvent sound = null;
        private ChatFormatting defaultColor = ChatFormatting.AQUA;

        public static Builder get() {
            return new Builder();
        }

        public Builder withTexture(ResourceLocation backgroundTexture) {
            this.backgroundTexture = backgroundTexture;
            return this;
        }

        public Builder withDesc(Component desc) {
            this.desc = desc;
            return this;
        }

        public Builder withTitle(Component name) {
            this.name = name;
            return this;
        }

        public Builder withDisplayItem(ItemLike displayItem) {
            this.displayItem = displayItem.m_5456_();
            return this;
        }

        public Builder withSound(SoundEvent sound) {
            this.sound = sound;
            return this;
        }

        public Builder withTitleColor(ChatFormatting color) {
            this.defaultColor = color;
            return this;
        }

        public SkiesToast build() {
            return new SkiesToast(this.name, this.desc, this.sound, this.backgroundTexture, this.displayItem, this.defaultColor);
        }
    }
}

