/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.shape;

import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.crops.CropLikeRegistry;
import dev.ftb.mods.ftbultimine.crops.VanillaCropLikeHandler;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.state.BlockState;

@FunctionalInterface
public interface BlockMatcher {
    public static final BlockMatcher MATCH = (original, state) -> original.m_60734_() == state.m_60734_();
    public static final BlockMatcher TAGS_MATCH_SHAPELESS = FTBUltimineServerConfig.MERGE_TAGS_SHAPELESS::match;
    public static final BlockMatcher TAGS_MATCH_SHAPED = FTBUltimineServerConfig.MERGE_TAGS_SHAPED::match;
    public static final BlockMatcher CROP_LIKE = (original, state) -> VanillaCropLikeHandler.equivalentForSelection(original, state) || CropLikeRegistry.getInstance().areStatesEquivalent(original, state);

    public boolean check(BlockState var1, BlockState var2);

    default public boolean actualCheck(BlockState original, BlockState state) {
        return (TagCache.isEmptyBlockWhitelist() || state.m_204336_(FTBUltimine.BLOCK_WHITELIST)) && !state.m_204336_(FTBUltimine.EXCLUDED_BLOCKS) && this.check(original, state);
    }

    public static class TagCache {
        private static Boolean emptyBlockWhitelist = null;

        private static boolean isEmptyBlockWhitelist() {
            if (emptyBlockWhitelist == null) {
                emptyBlockWhitelist = BuiltInRegistries.f_256975_.m_203431_(FTBUltimine.BLOCK_WHITELIST).map(holders -> holders.m_203632_() == 0).orElse(true);
            }
            return emptyBlockWhitelist;
        }

        public static void onReload() {
            emptyBlockWhitelist = null;
        }
    }
}

