/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.item;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.plant.AgriPlant;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ClipperItem
extends Item {
    public ClipperItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        return AgriApi.getCrop((BlockGetter)level, pos).map(crop -> {
            AgriPlant plant = crop.getPlant();
            if (plant == null) {
                return InteractionResult.FAIL;
            }
            if (!plant.allowsClipping(crop.getGrowthStage(), context.m_43722_(), (LivingEntity)player)) {
                if (player != null) {
                    player.m_213846_((Component)Component.m_237115_((String)"agricraft.message.clipping_impossible"));
                }
                return InteractionResult.FAIL;
            }
            ArrayList drops = new ArrayList();
            crop.getClippingProducts(drops::add, context.m_43722_());
            crop.setGrowthStage(plant.getInitialGrowthStage());
            for (ItemStack drop : drops) {
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, drop));
            }
            plant.onClipped((AgriCrop)crop, context.m_43722_(), (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.FAIL);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"agricraft.tooltip.clipper").m_130940_(ChatFormatting.DARK_GRAY));
    }
}

