/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.handler;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriSeed;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.common.block.CropBlock;
import com.agricraft.agricraft.common.block.CropState;
import com.agricraft.agricraft.common.block.entity.SeedAnalyzerBlockEntity;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.registry.ModBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class VanillaSeedConversion {
    public static InteractionResult onRightClick(Player player, InteractionHand hand, BlockPos pos, BlockHitResult blockHitResult) {
        Optional genome2;
        SeedAnalyzerBlockEntity seedAnalyzer;
        BlockEntity blockEntity;
        ItemStack heldItem = player.m_21120_(hand);
        if (!CoreConfig.overrideVanillaFarming || heldItem.m_41619_() || heldItem.m_41720_() instanceof AgriSeedItem || AgriApi.getCrop((BlockGetter)player.m_9236_(), pos).isPresent()) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_() && (blockEntity = player.m_9236_().m_7702_(pos)) instanceof SeedAnalyzerBlockEntity && !(seedAnalyzer = (SeedAnalyzerBlockEntity)blockEntity).hasSeed() && (genome2 = AgriApi.getGenomeAdapter(heldItem).flatMap(adapter -> adapter.valueOf(heldItem))).isPresent()) {
            seedAnalyzer.insertSeed(AgriSeedItem.toStack((AgriGenome)genome2.get()));
            heldItem.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (!CoreConfig.convertSeedsOnlyInAnalyzer) {
            BlockPos cropPos = pos.m_121945_(blockHitResult.m_82434_());
            return AgriApi.getGenomeAdapter(heldItem).flatMap(adapter -> adapter.valueOf(heldItem)).map(genome -> {
                AgriPlant plant = AgriApi.getPlant(genome.getSpeciesGene().getTrait()).get();
                AgriSeed seed = plant.getSeed(heldItem);
                if (!seed.overridePlanting()) {
                    return InteractionResult.PASS;
                }
                return AgriApi.getSoil(player.m_9236_(), cropPos.m_7495_()).map(soil -> {
                    InteractionResult[] consumed = new InteractionResult[]{InteractionResult.FAIL};
                    boolean cropStick = AgriApi.getCrop((BlockGetter)player.m_9236_(), cropPos).map(crop -> {
                        if (!crop.hasPlant() && !crop.isCrossCropSticks()) {
                            VanillaSeedConversion.plantSeedOnCrop(player, hand, crop, genome);
                            consumed[0] = InteractionResult.SUCCESS;
                            return true;
                        }
                        return true;
                    }).orElse(false);
                    if (cropStick) {
                        return consumed[0];
                    }
                    if (player.m_9236_().m_8055_(cropPos).m_60795_() && CoreConfig.plantOffCropSticks) {
                        player.m_9236_().m_7731_(cropPos, (BlockState)((Block)ModBlocks.CROP.get()).m_49966_().m_61124_(CropBlock.CROP_STATE, (Comparable)((Object)CropState.PLANT)), 3);
                        VanillaSeedConversion.plantSeedOnCrop(player, hand, AgriApi.getCrop((BlockGetter)player.m_9236_(), cropPos).get(), genome);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }).orElse(InteractionResult.PASS);
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }

    private static void plantSeedOnCrop(Player player, InteractionHand hand, AgriCrop crop, AgriGenome genome) {
        crop.plantGenome(genome);
        if (player != null) {
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            player.m_6674_(hand);
        }
    }
}

