/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.block;

import com.agricraft.agricraft.common.block.entity.SeedAnalyzerBlockEntity;
import com.agricraft.agricraft.common.registry.ModBlocks;
import com.agricraft.agricraft.common.util.Platform;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SeedAnalyzerBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty JOURNAL = BooleanProperty.m_61465_((String)"journal");
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);

    public SeedAnalyzerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60913_(2.0f, 3.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)JOURNAL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{JOURNAL, BlockStateProperties.f_61374_});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        ItemStack heldItem = player.m_21120_(hand);
        if (!(blockEntity instanceof SeedAnalyzerBlockEntity)) {
            return InteractionResult.FAIL;
        }
        SeedAnalyzerBlockEntity analyzer = (SeedAnalyzerBlockEntity)blockEntity;
        if (player.m_6144_()) {
            if (analyzer.hasSeed()) {
                ItemStack seed = analyzer.extractSeed();
                if (!player.m_36356_(seed)) {
                    level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, seed));
                }
                return InteractionResult.CONSUME;
            }
            if (analyzer.hasJournal()) {
                if (heldItem.m_41619_()) {
                    ItemStack journal = analyzer.extractJournal();
                    player.m_21008_(hand, journal);
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.FAIL;
        }
        if (!level.f_46443_) {
            Platform.get().openMenu((ServerPlayer)player, analyzer);
        }
        return InteractionResult.CONSUME;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        List drops = super.m_49635_(state, params);
        drops.add(((Block)ModBlocks.SEED_ANALYZER.get()).m_5456_().m_7968_());
        BlockEntity blockEntity = (BlockEntity)params.m_287261_(LootContextParams.f_81462_);
        if (blockEntity instanceof SeedAnalyzerBlockEntity) {
            SeedAnalyzerBlockEntity analyzer = (SeedAnalyzerBlockEntity)blockEntity;
            if (analyzer.hasSeed()) {
                drops.add(analyzer.getSeed());
            }
            if (analyzer.hasJournal()) {
                drops.add(analyzer.getJournal());
            }
        }
        return drops;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SeedAnalyzerBlockEntity(pos, state);
    }
}

