/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.block;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.fertilizer.AgriFertilizer;
import com.agricraft.agricraft.api.fertilizer.IAgriFertilizable;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.client.ClientUtil;
import com.agricraft.agricraft.common.block.CropState;
import com.agricraft.agricraft.common.block.CropStickVariant;
import com.agricraft.agricraft.common.block.SimpleFluidloggedBlock;
import com.agricraft.agricraft.common.block.entity.CropBlockEntity;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.item.CropSticksItem;
import com.agricraft.agricraft.common.registry.ModItems;
import com.agricraft.agricraft.common.util.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropBlock
extends Block
implements EntityBlock,
BonemealableBlock,
SimpleFluidloggedBlock {
    public static final VoxelShape SINGLE_STICKS = Stream.of(Block.m_49796_((double)2.0, (double)-3.0, (double)2.0, (double)3.0, (double)14.0, (double)3.0), Block.m_49796_((double)13.0, (double)-3.0, (double)2.0, (double)14.0, (double)14.0, (double)3.0), Block.m_49796_((double)2.0, (double)-3.0, (double)13.0, (double)3.0, (double)14.0, (double)14.0), Block.m_49796_((double)13.0, (double)-3.0, (double)13.0, (double)14.0, (double)14.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape CROSS_STICKS = Stream.of(SINGLE_STICKS, Block.m_49796_((double)0.0, (double)11.0, (double)2.0, (double)16.0, (double)12.0, (double)3.0), Block.m_49796_((double)0.0, (double)11.0, (double)13.0, (double)16.0, (double)12.0, (double)14.0), Block.m_49796_((double)2.0, (double)11.0, (double)0.0, (double)3.0, (double)12.0, (double)16.0), Block.m_49796_((double)13.0, (double)11.0, (double)0.0, (double)14.0, (double)12.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape CROP_STICKS = Stream.of(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)14.0, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)3.0), Block.m_49796_((double)2.0, (double)0.0, (double)13.0, (double)3.0, (double)14.0, (double)14.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)14.0, (double)14.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final EnumProperty<CropStickVariant> STICK_VARIANT = EnumProperty.m_61598_((String)"variant", CropStickVariant.class, (Enum[])CropStickVariant.values());
    public static final EnumProperty<CropState> CROP_STATE = EnumProperty.m_61598_((String)"crop", CropState.class, (Enum[])CropState.values());
    public static final IntegerProperty LIGHT = IntegerProperty.m_61631_((String)"light", (int)0, (int)16);
    private static final ItemStack BONE_MEAL = new ItemStack((ItemLike)Items.f_42499_);

    public CropBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_278166_(PushReaction.DESTROY).m_60924_((state, getter, pos) -> false).m_60977_().m_60955_().m_280574_().m_246721_().m_60953_(blockState -> (Integer)blockState.m_61143_((Property)LIGHT)).m_60918_(SoundType.f_56758_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SimpleFluidloggedBlock.LAVALOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SimpleFluidloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(STICK_VARIANT, (Comparable)((Object)CropStickVariant.WOODEN))).m_61124_(CROP_STATE, (Comparable)((Object)CropState.SINGLE_STICKS))).m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    public static void spawnItem(Level level, BlockPos pos, ItemStack stack) {
        level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack));
    }

    public static InteractionResult applyCropSticks(Level level, BlockPos pos, BlockState state, CropStickVariant variant) {
        if (variant == null) {
            return InteractionResult.FAIL;
        }
        if (level.m_5776_()) {
            return InteractionResult.PASS;
        }
        CropState cropState = (CropState)((Object)state.m_61143_(CROP_STATE));
        BlockState newState = state;
        if (cropState == CropState.PLANT) {
            newState = (BlockState)state.m_61124_(CROP_STATE, (Comparable)((Object)CropState.PLANT_STICKS));
        } else if (cropState == CropState.SINGLE_STICKS && state.m_61143_(STICK_VARIANT) == variant) {
            newState = (BlockState)state.m_61124_(CROP_STATE, (Comparable)((Object)CropState.DOUBLE_STICKS));
        }
        if (newState == state) {
            return InteractionResult.FAIL;
        }
        level.m_7731_(pos, newState, 3);
        if (cropState.hasSticks()) {
            variant.playSound(level, pos);
        } else {
            SoundType sound = Blocks.f_50092_.m_49962_(Blocks.f_50092_.m_49966_());
            level.m_5594_(null, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionResultHolder<CropStickVariant> removeCropSticks(Level level, BlockPos pos, BlockState state) {
        CropStickVariant stickVariant = (CropStickVariant)((Object)state.m_61143_(STICK_VARIANT));
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)((Object)stickVariant));
        }
        CropState cropState = (CropState)((Object)state.m_61143_(CROP_STATE));
        BlockState newState = state;
        if (!cropState.hasPlant()) {
            newState = (BlockState)state.m_61124_(CROP_STATE, (Comparable)((Object)CropState.SINGLE_STICKS));
        }
        if (newState == state) {
            return InteractionResultHolder.m_19100_((Object)((Object)stickVariant));
        }
        level.m_7731_(pos, newState, 3);
        if (cropState == CropState.DOUBLE_STICKS) {
            stickVariant.playSound(level, pos);
        }
        return InteractionResultHolder.m_19090_((Object)((Object)stickVariant));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SimpleFluidloggedBlock.LAVALOGGED});
        builder.m_61104_(new Property[]{SimpleFluidloggedBlock.WATERLOGGED});
        builder.m_61104_(new Property[]{STICK_VARIANT});
        builder.m_61104_(new Property[]{CROP_STATE});
        builder.m_61104_(new Property[]{LIGHT});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        CropState cropState = (CropState)((Object)state.m_61143_(CROP_STATE));
        if (cropState == CropState.DOUBLE_STICKS) {
            return CROSS_STICKS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CropBlockEntity) {
            CropBlockEntity cbe = (CropBlockEntity)blockEntity;
            if (!cbe.hasPlant() && !cbe.hasWeeds()) {
                return SINGLE_STICKS;
            }
            return cropState.hasSticks() ? Shapes.m_83113_((VoxelShape)CROP_STICKS, (VoxelShape)cbe.getShape(), (BooleanOp)BooleanOp.f_82695_) : cbe.getShape();
        }
        return super.m_5940_(state, level, pos, context);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        CropState cropState = (CropState)((Object)state.m_61143_(CROP_STATE));
        if (CoreConfig.cropSticksCollide && cropState.hasSticks()) {
            return cropState == CropState.DOUBLE_STICKS ? CROSS_STICKS : SINGLE_STICKS;
        }
        return Shapes.m_83040_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        if (context.m_43725_().m_6425_(context.m_8083_()).m_192917_((Fluid)Fluids.f_76195_)) {
            state = (BlockState)state.m_61124_((Property)SimpleFluidloggedBlock.LAVALOGGED, (Comparable)Boolean.valueOf(true));
        } else if (context.m_43725_().m_6425_(context.m_8083_()).m_192917_((Fluid)Fluids.f_76193_)) {
            state = (BlockState)state.m_61124_((Property)SimpleFluidloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        ItemStack stack = context.m_43722_();
        if (stack.m_41720_() instanceof CropSticksItem) {
            state = this.blockStateCropStick(state, CropStickVariant.fromItem(stack));
        } else if (stack.m_41720_() instanceof AgriSeedItem) {
            if (!CoreConfig.plantOffCropSticks) {
                return null;
            }
            state = this.blockStatePlant(state);
        }
        return state;
    }

    public BlockState blockStateCropStick(BlockState state, CropStickVariant variant) {
        return (BlockState)state.m_61124_(STICK_VARIANT, (Comparable)((Object)variant));
    }

    public BlockState blockStatePlant(BlockState state) {
        return (BlockState)state.m_61124_(CROP_STATE, (Comparable)((Object)CropState.PLANT));
    }

    @NotNull
    public FluidState m_5888_(BlockState pState) {
        if (((Boolean)pState.m_61143_((Property)SimpleFluidloggedBlock.LAVALOGGED)).booleanValue()) {
            return Fluids.f_76195_.m_76068_(false);
        }
        if (((Boolean)pState.m_61143_((Property)SimpleFluidloggedBlock.WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(pState);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return Platform.get().createCropBlockEntity(pos, state);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Optional<InteractionResult> override;
        InteractionResult result;
        Optional<AgriCrop> optional = AgriApi.getCrop((BlockGetter)level, pos);
        if (optional.isEmpty()) {
            return InteractionResult.FAIL;
        }
        AgriCrop crop = optional.get();
        if (crop.hasPlant() && (result = crop.getPlant().onRightClickPre(crop, player.m_21120_(hand), (Entity)player)).isPresent()) {
            return (InteractionResult)result.get();
        }
        result = this.rightClickLogic(player.m_21120_(hand), state, level, pos, player, hand, crop);
        if (crop.hasPlant() && (override = crop.getPlant().onRightClickPost(crop, player.m_21120_(hand), (Entity)player)).isPresent()) {
            return override.get();
        }
        return result;
    }

    protected InteractionResult rightClickLogic(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, AgriCrop crop) {
        InteractionResult result;
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (heldItem.m_150930_((Item)ModItems.CLIPPER.get()) || heldItem.m_150930_((Item)ModItems.IRON_RAKE.get()) || heldItem.m_150930_((Item)ModItems.WOODEN_RAKE.get())) {
            return InteractionResult.PASS;
        }
        if (AgriApi.getFertilizerAdapter(heldItem).isPresent()) {
            return AgriApi.getFertilizerAdapter(heldItem).get().valueOf(heldItem).map(fertilizer -> {
                if (crop.acceptsFertilizer((AgriFertilizer)fertilizer)) {
                    InteractionResult result = fertilizer.applyFertilizer(level, pos, crop, heldItem, level.f_46441_, (LivingEntity)player);
                    if (result == InteractionResult.CONSUME || result == InteractionResult.SUCCESS) {
                        crop.onApplyFertilizer((AgriFertilizer)fertilizer, level.f_46441_);
                        if (crop.hasPlant()) {
                            crop.getPlant().onFertilized(crop, heldItem, level.f_46441_);
                        }
                    }
                    return result;
                }
                return InteractionResult.CONSUME;
            }).orElse(InteractionResult.PASS);
        }
        if (heldItem.m_41720_() instanceof CropSticksItem && (result = CropBlock.applyCropSticks(level, pos, state, CropStickVariant.fromItem(heldItem))) == InteractionResult.SUCCESS) {
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            return result;
        }
        Optional genome = AgriApi.getGenomeAdapter(heldItem).flatMap(adapter -> adapter.valueOf(heldItem));
        if (genome.isPresent()) {
            if (!crop.isCrossCropSticks() && !crop.hasPlant()) {
                crop.plantGenome((AgriGenome)genome.get());
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (crop.isCrossCropSticks()) {
            InteractionResultHolder<CropStickVariant> result2 = CropBlock.removeCropSticks(level, pos, state);
            if (result2.m_19089_() == InteractionResult.SUCCESS) {
                if (!player.m_7500_()) {
                    CropBlock.spawnItem(level, pos, CropStickVariant.toItem((CropStickVariant)((Object)result2.m_19095_())));
                }
                return InteractionResult.CONSUME;
            }
        } else if (crop.hasPlant() && crop.canBeHarvested()) {
            crop.harvest(itemStack -> CropBlock.spawnItem(level, pos, itemStack), (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AgriCrop) {
            AgriCrop crop = (AgriCrop)blockEntity;
            if (crop.hasPlant()) {
                return AgriSeedItem.toStack(crop.getGenome());
            }
            if (crop.hasCropSticks()) {
                return CropStickVariant.toItem((CropStickVariant)((Object)state.m_61143_(STICK_VARIANT)));
            }
        }
        return super.m_7397_(level, pos, state);
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        this.spawnDestroyParticles((LevelAccessor)level, state, pos);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)SimpleFluidloggedBlock.LAVALOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76195_, Fluids.f_76195_.m_6718_((LevelReader)level));
        } else if (((Boolean)state.m_61143_((Property)SimpleFluidloggedBlock.WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (!state.m_60710_((LevelReader)level, pos)) {
            this.spawnDestroyParticles(level, state, pos);
            if (((Boolean)state.m_61143_((Property)SimpleFluidloggedBlock.LAVALOGGED)).booleanValue()) {
                return Fluids.f_76195_.m_76145_().m_76188_();
            }
            if (((Boolean)state.m_61143_((Property)SimpleFluidloggedBlock.WATERLOGGED)).booleanValue()) {
                return Fluids.f_76193_.m_76145_().m_76188_();
            }
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return AgriApi.getSoil((BlockGetter)level, pos.m_7495_(), level.m_9598_()).isPresent();
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return AgriApi.getCrop((BlockGetter)level, pos).map(crop -> crop.hasPlant() && crop.isFertile() && !crop.isFullyGrown()).orElse(false);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return AgriApi.getFertilizer(BONE_MEAL).flatMap(fertilizer -> AgriApi.getCrop((BlockGetter)level, pos).map(crop -> !crop.isFullyGrown() && crop.acceptsFertilizer((AgriFertilizer)fertilizer))).orElse(false);
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        AgriApi.getFertilizer(BONE_MEAL).ifPresent(fertilizer -> AgriApi.getCrop((BlockGetter)level, pos).ifPresent(crop -> fertilizer.applyFertilizer((Level)level, pos, (IAgriFertilizable)crop, BONE_MEAL, random, null)));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (state.m_61143_(STICK_VARIANT) == CropStickVariant.WOODEN && level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76195_)) {
            this.spawnDestroyParticles((LevelAccessor)level, state, pos);
            level.m_46961_(pos, true);
            return;
        }
        AgriApi.getCrop((BlockGetter)level, pos).ifPresent(agriCrop -> {
            if (agriCrop.hasPlant()) {
                agriCrop.getPlant().onRandomTick((AgriCrop)agriCrop, random);
            }
            agriCrop.applyGrowthTick();
        });
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        AgriApi.getCrop((BlockGetter)level, pos).ifPresent(crop -> {
            if (crop.hasPlant()) {
                crop.getPlant().spawnParticles((AgriCrop)crop, random);
            }
        });
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        AgriApi.getCrop((BlockGetter)level, pos).ifPresent(crop -> {
            if (crop.hasPlant()) {
                crop.getPlant().onBroken((AgriCrop)crop, (LivingEntity)player);
            }
        });
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        BlockEntity tile = (BlockEntity)params.m_287159_(LootContextParams.f_81462_);
        if (tile == null) {
            return drops;
        }
        CropState cropState = (CropState)((Object)state.m_61143_(CROP_STATE));
        if (cropState.hasSticks()) {
            drops.add(CropStickVariant.toItem((CropStickVariant)((Object)state.m_61143_(STICK_VARIANT)), cropState == CropState.DOUBLE_STICKS ? 2 : 1));
        }
        if (tile instanceof AgriCrop) {
            AgriCrop crop = (AgriCrop)tile;
            crop.getHarvestProducts(drops::add);
            if (crop.hasPlant() && (crop.isFullyGrown() || !CoreConfig.onlyMatureSeedDrops)) {
                drops.add(AgriSeedItem.toStack(crop.getGenome()));
            }
        }
        return drops;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(state, level, pos, entity);
        AgriApi.getCrop((BlockGetter)level, pos).ifPresent(crop -> {
            if (crop.hasPlant()) {
                crop.getPlant().onEntityCollision((AgriCrop)crop, entity);
            }
        });
    }

    public boolean m_7899_(BlockState state) {
        return ((CropState)((Object)state.m_61143_(CROP_STATE))).hasPlant();
    }

    public boolean m_7278_(BlockState state) {
        return ((CropState)((Object)state.m_61143_(CROP_STATE))).hasPlant();
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return super.m_6376_(state, (BlockGetter)level, pos, null);
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.m_6376_(state, level, pos, direction);
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return ((CropState)((Object)state.m_61143_(CROP_STATE))).hasPlant() ? AgriApi.getCrop(level, pos).map(crop -> {
            if (crop.getPlant() != null) {
                return crop.getPlant().getRedstonePower((AgriCrop)crop);
            }
            return 0;
        }).orElse(0) : 0;
    }

    private void spawnDestroyParticles(LevelAccessor level, BlockState state, BlockPos pos) {
        BlockEntity blockEntity;
        if (level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof AgriCrop) {
            AgriCrop crop = (AgriCrop)blockEntity;
            CropState cropState = (CropState)((Object)state.m_61143_(CROP_STATE));
            if (cropState.hasSticks()) {
                if (cropState == CropState.DOUBLE_STICKS) {
                    ClientUtil.spawnParticlesForSticks((CropStickVariant)((Object)state.m_61143_(STICK_VARIANT)), level, state, pos, CROSS_STICKS);
                } else {
                    ClientUtil.spawnParticlesForSticks((CropStickVariant)((Object)state.m_61143_(STICK_VARIANT)), level, state, pos, SINGLE_STICKS);
                }
            }
            if (crop.hasPlant()) {
                String plantModelId = crop.getPlantId().replace(":", ":crop/") + "_stage" + crop.getGrowthStage().index();
                BlockEntity blockEntity2 = level.m_7702_(pos);
                if (blockEntity2 instanceof CropBlockEntity) {
                    CropBlockEntity cbe = (CropBlockEntity)blockEntity2;
                    ClientUtil.spawnParticlesForPlant(plantModelId, level, state, pos, cbe.getShape());
                }
            }
        }
    }
}

