/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.genetic;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriMutation;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.genetic.AgriAllele;
import com.agricraft.agricraft.api.genetic.AgriCrossBreedEngine;
import com.agricraft.agricraft.api.genetic.AgriGene;
import com.agricraft.agricraft.api.genetic.AgriGeneMutator;
import com.agricraft.agricraft.api.genetic.AgriGenePair;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.util.RandomSource;

public class AgriMutationHandler {
    private static final AgriMutationHandler INSTANCE = new AgriMutationHandler();
    private AgriCrossBreedEngine engine = new AgriCrossBreedEngine();
    private AgriGeneMutator<String> plantMutator = new DefaultPlantMutator();
    private AgriGeneMutator<Integer> statMutator = new DefaultStatMutator();
    private final Map<String, Integer> complexities = new HashMap<String, Integer>();
    private boolean computed = false;

    public static AgriMutationHandler getInstance() {
        return INSTANCE;
    }

    private AgriMutationHandler() {
    }

    public AgriCrossBreedEngine getActiveCrossBreedEngine() {
        return this.engine;
    }

    public void setCrossBreedEngine(AgriCrossBreedEngine engine) {
        this.engine = engine;
    }

    public AgriGeneMutator<String> getActivePlantMutator() {
        return this.plantMutator;
    }

    public void setActivePlantMutator(AgriGeneMutator<String> mutator) {
        this.plantMutator = mutator;
    }

    public AgriGeneMutator<Integer> getActiveStatMutator() {
        return this.statMutator;
    }

    public void setActiveStatMutator(AgriGeneMutator<Integer> mutator) {
        this.statMutator = mutator;
    }

    public int complexity(String plant) {
        if (!this.computed) {
            this.computed = true;
            this.setupComplexities();
        }
        return this.complexities.getOrDefault(plant, 0);
    }

    protected void setupComplexities() {
        Optional<Registry<AgriMutation>> op = AgriApi.getMutationRegistry();
        if (op.isPresent()) {
            Registry<AgriMutation> registry = op.get();
            for (AgriMutation mutation : registry) {
                if (!mutation.isValid() || !this.updateComplexity(mutation.child().toString())) continue;
                this.updateComplexityForChildren(mutation.child().toString());
            }
        }
    }

    protected boolean updateComplexity(String plant) {
        int oldComplexity;
        int newComplexity = this.calculateComplexity(plant);
        if (newComplexity != (oldComplexity = this.complexity(plant))) {
            if (newComplexity == 0) {
                this.complexities.remove(plant);
            } else {
                this.complexities.put(plant, newComplexity);
            }
            return true;
        }
        return false;
    }

    protected void updateComplexityForChildren(String plant) {
        Set visited = Sets.newIdentityHashSet();
        visited.add(plant);
        this.updateComplexityForChildren(plant, visited);
    }

    protected void updateComplexityForChildren(String plant, Set<String> visited) {
        AgriApi.getMutationRegistry().ifPresent(registry -> registry.m_123024_().filter(mutation -> mutation.parent1().toString().equals(plant) || mutation.parent2().toString().equals(plant)).map(mutation -> {
            String child = mutation.child().toString();
            if (visited.contains(child)) {
                return null;
            }
            if (this.updateComplexity(child)) {
                visited.add(child);
                return child;
            }
            return null;
        }).filter(Objects::nonNull).forEach(child -> this.updateComplexityForChildren((String)child, visited)));
    }

    protected int calculateComplexity(String plant) {
        return AgriApi.getMutationRegistry().map(registry -> registry.m_123024_().filter(mutation -> mutation.child().toString().equals(plant)).mapToInt(this::calculateComplexity).min().orElse(0)).orElse(0);
    }

    protected int calculateComplexity(AgriMutation mutation) {
        return this.complexity(mutation.parent1().toString()) + this.complexity(mutation.parent2().toString()) + 1;
    }

    public static class DefaultPlantMutator
    implements AgriGeneMutator<String> {
        @Override
        public AgriGenePair<String> pickOrMutate(AgriCrop crop, AgriGene<String> gene, AgriAllele<String> first, AgriAllele<String> second, AgriGenome parent1, AgriGenome parent2, RandomSource random) {
            return AgriApi.getMutationsFromParents(first.trait(), second.trait()).min((a, b) -> this.sortAndShuffle((AgriMutation)a, (AgriMutation)b, random)).flatMap(m -> this.evaluate((AgriMutation)m, random)).map(plant -> new AgriGenePair<String>(gene, gene.getAllele((String)plant), random.m_188499_() ? first : second)).orElse(new AgriGenePair<String>(gene, first, second));
        }

        protected int sortAndShuffle(AgriMutation a, AgriMutation b, RandomSource random) {
            return a == b ? 0 : (random.m_188499_() ? -1 : 1);
        }

        protected Optional<String> evaluate(AgriMutation mutation, RandomSource random) {
            if (mutation.chance() > random.m_188500_()) {
                return Optional.of(mutation.child().toString());
            }
            return Optional.empty();
        }
    }

    public static class DefaultStatMutator
    implements AgriGeneMutator<Integer> {
        @Override
        public AgriGenePair<Integer> pickOrMutate(AgriCrop crop, AgriGene<Integer> gene, AgriAllele<Integer> first, AgriAllele<Integer> second, AgriGenome parent1, AgriGenome parent2, RandomSource random) {
            AgriStat mutativity = AgriStatRegistry.getInstance().mutativityStat();
            return new AgriGenePair<Integer>(gene, this.rollAndExecuteMutation(gene, first, mutativity, parent1.getMutativity(), random), this.rollAndExecuteMutation(gene, second, mutativity, parent2.getMutativity(), random));
        }

        protected AgriAllele<Integer> rollAndExecuteMutation(AgriGene<Integer> gene, AgriAllele<Integer> allele, AgriStat mutativity, int statValue, RandomSource random) {
            int max = mutativity.getMax();
            if ((double)random.m_188501_() >= (1.0 - (double)statValue / (double)max) / 2.0) {
                int delta = random.m_188503_(max) < (max + statValue) / 2 ? 1 : -1;
                return gene.getAllele(allele.trait() + delta);
            }
            return allele;
        }
    }
}

