/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.genetic;

import com.agricraft.agricraft.api.genetic.AgriGenePair;
import com.agricraft.agricraft.api.genetic.AgriGeneRegistry;
import com.agricraft.agricraft.api.genetic.GeneSpecies;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;

public class AgriGenome {
    private final AgriGenePair<String> species;
    private final Map<String, AgriGenePair<Integer>> stats;

    public AgriGenome(AgriGenePair<String> species, List<AgriGenePair<Integer>> stats) {
        this.species = species;
        this.stats = new HashMap<String, AgriGenePair<Integer>>();
        for (AgriGenePair<Integer> gene : stats) {
            this.stats.put(gene.getGene().getId(), gene);
        }
    }

    public AgriGenome(AgriPlant plant) {
        GeneSpecies geneSpecies = AgriGeneRegistry.getInstance().getGeneSpecies();
        this.species = new AgriGenePair<String>(geneSpecies, geneSpecies.defaultAllele(plant));
        this.stats = new HashMap<String, AgriGenePair<Integer>>();
        for (AgriStat stat : AgriStatRegistry.getInstance()) {
            AgriGeneRegistry.getInstance().getGeneStat(stat).ifPresent(gene -> this.stats.put(gene.getId(), new AgriGenePair(gene, gene.defaultAllele(plant))));
        }
    }

    public static AgriGenome fromNBT(CompoundTag tag) {
        if (tag == null || !tag.m_128441_("genes")) {
            return null;
        }
        CompoundTag genes = tag.m_128469_("genes");
        AgriGenePair<String> species = AgriGeneRegistry.getInstance().getGeneSpecies().readFromNBT(genes);
        ArrayList<AgriGenePair<Integer>> stats = new ArrayList<AgriGenePair<Integer>>();
        for (AgriStat stat : AgriStatRegistry.getInstance()) {
            AgriGeneRegistry.getInstance().getGeneStat(stat).ifPresent(gene -> stats.add(gene.readFromNBT(genes)));
        }
        return new AgriGenome(species, stats);
    }

    public static void removeFromNBT(CompoundTag tag) {
        tag.m_128473_("genes");
    }

    public AgriGenePair<String> getSpeciesGene() {
        return this.species;
    }

    public AgriGenePair<Integer> getStatGene(AgriStat stat) {
        return this.stats.get(stat.getId());
    }

    public int getGain() {
        return this.getStatGene(AgriStatRegistry.getInstance().gainStat()).getTrait();
    }

    public int getGrowth() {
        return this.getStatGene(AgriStatRegistry.getInstance().growthStat()).getTrait();
    }

    public int getStrength() {
        return this.getStatGene(AgriStatRegistry.getInstance().strengthStat()).getTrait();
    }

    public int getFertility() {
        return this.getStatGene(AgriStatRegistry.getInstance().fertilityStat()).getTrait();
    }

    public int getResistance() {
        return this.getStatGene(AgriStatRegistry.getInstance().resistanceStat()).getTrait();
    }

    public int getMutativity() {
        return this.getStatGene(AgriStatRegistry.getInstance().mutativityStat()).getTrait();
    }

    public Collection<AgriGenePair<Integer>> getStatGenes() {
        return this.stats.values();
    }

    public void writeToNBT(CompoundTag tag) {
        CompoundTag genes = new CompoundTag();
        this.species.getGene().writeToNBT(genes, this.species.getDominant(), this.species.getRecessive());
        for (AgriGenePair<Integer> statPair : this.stats.values()) {
            statPair.getGene().writeToNBT(genes, statPair.getDominant(), statPair.getRecessive());
        }
        tag.m_128365_("genes", (Tag)genes);
    }

    public String toString() {
        CompoundTag compoundTag = new CompoundTag();
        this.writeToNBT(compoundTag);
        return compoundTag.toString();
    }

    public void appendHoverText(List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (isAdvanced.m_7050_()) {
            this.getSpeciesGene().getGene().addTooltip(tooltipComponents, this.getSpeciesGene().getTrait());
        }
        this.getStatGenes().stream().sorted(Comparator.comparing(pair -> pair.getGene().getId())).forEach(pair -> pair.getGene().addTooltip(tooltipComponents, (Integer)pair.getTrait()));
    }
}

