/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.genetic;

import com.agricraft.agricraft.api.genetic.AgriAllele;
import com.agricraft.agricraft.api.genetic.AgriGene;

public class AgriGenePair<T> {
    private final AgriGene<T> gene;
    private final AgriAllele<T> dominant;
    private final AgriAllele<T> recessive;

    public AgriGenePair(AgriGene<T> gene, AgriAllele<T> first, AgriAllele<T> second) {
        this.gene = gene;
        if (first.isDominant(second)) {
            this.dominant = first;
            this.recessive = second;
        } else {
            this.dominant = second;
            this.recessive = first;
        }
    }

    public AgriGenePair(AgriGene<T> gene, AgriAllele<T> both) {
        this.gene = gene;
        this.dominant = both;
        this.recessive = both;
    }

    public AgriGene<T> getGene() {
        return this.gene;
    }

    public T getTrait() {
        return this.getDominant().trait();
    }

    public final AgriAllele<T> getDominant() {
        return this.dominant;
    }

    public final AgriAllele<T> getRecessive() {
        return this.recessive;
    }

    public AgriGenePair<T> copy() {
        return new AgriGenePair<T>(this.getGene(), this.getDominant(), this.getRecessive());
    }
}

