/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.genetic;

import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.genetic.AgriAllele;
import com.agricraft.agricraft.api.genetic.AgriGenePair;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;

public class AgriCrossBreedEngine {
    private ParentSelector selector = this::selectAndSortCandidates;
    private CloneLogic cloner = (crop, parent, random) -> new AgriGenome(this.cloneGene(crop, parent.getSpeciesGene(), parent, random), parent.getStatGenes().stream().map(genePair -> this.cloneGene(crop, (AgriGenePair)genePair, parent, random)).collect(Collectors.toList()));
    private CombineLogic combiner = (crop, parent1, parent2, random) -> new AgriGenome(this.mutateGene(crop, parent1.getSpeciesGene(), parent2.getSpeciesGene(), parent1, parent2, random), AgriStatRegistry.getInstance().stream().map(stat -> this.mutateGene(crop, parent1.getStatGene((AgriStat)stat), parent2.getStatGene((AgriStat)stat), parent1, parent2, random)).collect(Collectors.toList()));

    protected ParentSelector getSelector() {
        return this.selector;
    }

    protected CloneLogic getCloner() {
        return this.cloner;
    }

    protected CombineLogic getCombiner() {
        return this.combiner;
    }

    public boolean handleCrossBreedTick(AgriCrop crop, Stream<AgriCrop> neighbours, RandomSource random) {
        List<AgriCrop> candidates = this.getSelector().selectAndOrder(neighbours, random);
        if (candidates.isEmpty()) {
            return false;
        }
        if (candidates.size() == 1) {
            return this.doClone(crop, candidates.get(0), random);
        }
        return this.doCombine(crop, candidates.get(0), candidates.get(1), random);
    }

    protected List<AgriCrop> selectAndSortCandidates(Stream<AgriCrop> neighbours, RandomSource random) {
        return neighbours.filter(AgriCrop::hasPlant).filter(AgriCrop::canBeHarvested).filter(crop -> !CoreConfig.onlyFertileCropsSpread || crop.isFertile()).sorted(Comparator.comparingInt(this::sorter)).filter(neighbour -> this.rollFertility((AgriCrop)neighbour, random)).collect(Collectors.toList());
    }

    protected boolean doClone(AgriCrop target, AgriCrop parent, RandomSource random) {
        AgriPlant plant = parent.getPlant();
        if (plant.allowsCloning(parent.getGrowthStage()) && random.m_188500_() < parent.getPlant().getSpreadChance(parent.getGrowthStage())) {
            AgriGenome clone = this.getCloner().clone(target, parent.getGenome(), random);
            target.plantGenome(clone);
            target.getPlant().onSpawned(target);
            return true;
        }
        return false;
    }

    protected boolean doCombine(AgriCrop target, AgriCrop a, AgriCrop b, RandomSource random) {
        AgriGenome genome = this.getCombiner().combine(target, a.getGenome(), b.getGenome(), random);
        target.plantGenome(genome);
        target.getPlant().onSpawned(target);
        return true;
    }

    protected int sorter(AgriCrop crop) {
        AgriStat fertility = AgriStatRegistry.getInstance().fertilityStat();
        return fertility.getMax() - crop.getGenome().getStatGene(AgriStatRegistry.getInstance().fertilityStat()).getTrait();
    }

    protected boolean rollFertility(AgriCrop crop, RandomSource random) {
        AgriStat fertility = AgriStatRegistry.getInstance().fertilityStat();
        return random.m_188503_(fertility.getMax()) < crop.getGenome().getStatGene(AgriStatRegistry.getInstance().fertilityStat()).getTrait();
    }

    protected <T> AgriGenePair<T> mutateGene(AgriCrop crop, AgriGenePair<T> genePair1, AgriGenePair<T> genePair2, AgriGenome parent1, AgriGenome parent2, RandomSource rand) {
        return genePair1.getGene().mutator().pickOrMutate(crop, genePair1.getGene(), this.pickRandomAllele(genePair1, rand), this.pickRandomAllele(genePair2, rand), parent1, parent2, rand);
    }

    protected <T> AgriGenePair<T> cloneGene(AgriCrop crop, AgriGenePair<T> genePair, AgriGenome parent, RandomSource rand) {
        if (CoreConfig.cloneMutations) {
            return genePair.getGene().mutator().pickOrMutate(crop, genePair.getGene(), genePair.getDominant(), genePair.getRecessive(), parent, parent, rand);
        }
        return genePair.copy();
    }

    protected <T> AgriAllele<T> pickRandomAllele(AgriGenePair<T> pair, RandomSource random) {
        return random.m_188499_() ? pair.getDominant() : pair.getRecessive();
    }

    void setSelectionLogic(ParentSelector selector) {
        this.selector = selector;
    }

    void setCloneLogic(CloneLogic cloneLogic) {
        this.cloner = cloneLogic;
    }

    void setCombineLogic(CombineLogic combineLogic) {
        this.combiner = combineLogic;
    }

    @FunctionalInterface
    public static interface ParentSelector {
        public List<AgriCrop> selectAndOrder(Stream<AgriCrop> var1, RandomSource var2);
    }

    @FunctionalInterface
    public static interface CloneLogic {
        public AgriGenome clone(AgriCrop var1, AgriGenome var2, RandomSource var3);
    }

    @FunctionalInterface
    public static interface CombineLogic {
        public AgriGenome combine(AgriCrop var1, AgriGenome var2, AgriGenome var3, RandomSource var4);
    }
}

