/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.fertilizer;

import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.fertilizer.AgriFertilizerParticle;
import com.agricraft.agricraft.api.fertilizer.AgriFertilizerVariant;
import com.agricraft.agricraft.api.fertilizer.IAgriFertilizable;
import com.agricraft.agricraft.common.util.Platform;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AgriFertilizer {
    public static final Codec<AgriFertilizer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("mods").forGetter(agriFertilizer -> agriFertilizer.mods), (App)AgriFertilizerVariant.CODEC.listOf().fieldOf("variants").forGetter(agriFertilizer -> agriFertilizer.variants), (App)Codec.BOOL.fieldOf("trigger_mutation").forGetter(agriFertilizer -> agriFertilizer.triggerMutation), (App)Codec.BOOL.fieldOf("trigger_weeds").forGetter(agriFertilizer -> agriFertilizer.triggerWeeds), (App)Codec.INT.fieldOf("potency").forGetter(agriFertilizer -> agriFertilizer.potency), (App)Codec.BOOL.fieldOf("reduce_growth").forGetter(agriFertilizer -> agriFertilizer.reduceGrowth), (App)Codec.BOOL.fieldOf("kill_plant").forGetter(agriFertilizer -> agriFertilizer.killPlant), (App)ExtraCodecs.f_216161_.listOf().fieldOf("neutral_on").forGetter(agriFertilizer -> agriFertilizer.neutralOn), (App)ExtraCodecs.f_216161_.listOf().fieldOf("negative_on").forGetter(agriFertilizer -> agriFertilizer.negativeOn), (App)AgriFertilizerParticle.CODEC.listOf().fieldOf("particles").forGetter(agriFertilizer -> agriFertilizer.particles)).apply((Applicative)instance, AgriFertilizer::new));
    private final List<String> mods;
    private final List<AgriFertilizerVariant> variants;
    private final boolean triggerMutation;
    private final boolean triggerWeeds;
    private final int potency;
    private final boolean reduceGrowth;
    private final boolean killPlant;
    private final List<ExtraCodecs.TagOrElementLocation> neutralOn;
    private final List<ExtraCodecs.TagOrElementLocation> negativeOn;
    private final List<AgriFertilizerParticle> particles;

    public AgriFertilizer(List<String> mods, List<AgriFertilizerVariant> variants, boolean triggerMutation, boolean triggerWeeds, int potency, boolean reduceGrowth, boolean killPlant, List<ExtraCodecs.TagOrElementLocation> neutralOn, List<ExtraCodecs.TagOrElementLocation> negativeOn, List<AgriFertilizerParticle> particles) {
        this.mods = mods;
        this.variants = variants;
        this.triggerMutation = triggerMutation;
        this.triggerWeeds = triggerWeeds;
        this.potency = potency;
        this.reduceGrowth = reduceGrowth;
        this.killPlant = killPlant;
        this.neutralOn = neutralOn;
        this.negativeOn = negativeOn;
        this.particles = particles;
    }

    public List<AgriFertilizerVariant> variants() {
        return this.variants;
    }

    public boolean canTriggerMutation() {
        return this.triggerMutation;
    }

    public boolean canTriggerWeeds() {
        return this.triggerWeeds;
    }

    public boolean canReduceGrowth() {
        return this.reduceGrowth;
    }

    public boolean canKillPlant() {
        return this.killPlant;
    }

    public boolean affects(ResourceLocation plantId) {
        return !this.isNeutralOn(plantId);
    }

    public boolean isNeutralOn(ResourceLocation plantId) {
        return this.neutralOn.stream().flatMap(tag -> Platform.get().getPlantIdsFromTag((ExtraCodecs.TagOrElementLocation)tag)).anyMatch(rl -> rl.equals((Object)plantId));
    }

    public boolean isNegativeOn(ResourceLocation plantId) {
        return this.negativeOn.stream().flatMap(tag -> Platform.get().getPlantIdsFromTag((ExtraCodecs.TagOrElementLocation)tag)).anyMatch(rl -> rl.equals((Object)plantId));
    }

    public List<AgriFertilizerParticle> getParticles(String type) {
        return this.particles.stream().filter(particle -> particle.when().contains(type)).collect(Collectors.toList());
    }

    public InteractionResult applyFertilizer(Level level, BlockPos pos, IAgriFertilizable fertilizable, ItemStack stack, RandomSource random, @Nullable LivingEntity entity) {
        if (fertilizable instanceof AgriCrop) {
            AgriCrop crop = (AgriCrop)fertilizable;
            String type = "neutral";
            for (int i = 0; i < this.potency; ++i) {
                if (this.isNegativeOn(new ResourceLocation(crop.getPlantId()))) {
                    AgriGrowthStage previous;
                    if (!this.canReduceGrowth() || !random.m_188499_()) continue;
                    type = "negative";
                    if (level.m_5776_()) continue;
                    AgriGrowthStage current = crop.getGrowthStage();
                    if (current.equals(previous = current.getPrevious(crop, random))) {
                        if (!this.canKillPlant()) continue;
                        crop.removeGenome();
                        continue;
                    }
                    crop.setGrowthStage(previous);
                    continue;
                }
                if (crop.hasPlant() && this.canFertilize(crop)) {
                    fertilizable.applyGrowthTick();
                    type = "positive";
                    continue;
                }
                if (crop.isCrossCropSticks() && this.canTriggerMutation()) {
                    fertilizable.applyGrowthTick();
                    type = "positive";
                    continue;
                }
                if (!this.canTriggerWeeds()) continue;
                fertilizable.applyGrowthTick();
                type = "positive";
            }
            this.spawnParticles(level, pos, type, random);
            if (entity instanceof Player && !((Player)entity).m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void spawnParticles(Level world, BlockPos pos, String type, RandomSource rand) {
        this.getParticles(type).forEach(effect -> {
            ParticleType particle = (ParticleType)BuiltInRegistries.f_257034_.m_7745_(new ResourceLocation(effect.particle()));
            if (!(particle instanceof ParticleOptions)) {
                return;
            }
            for (int amount = 0; amount < effect.amount(); ++amount) {
                double x = (double)pos.m_123341_() + 0.5 + (double)(rand.m_188499_() ? 1 : -1) * effect.deltaX() * rand.m_188500_();
                double y = (double)pos.m_123342_() + 0.5 + effect.deltaY() * rand.m_188500_();
                double z = (double)pos.m_123343_() + 0.5 + (double)(rand.m_188499_() ? 1 : -1) * effect.deltaZ() * rand.m_188500_();
                world.m_7106_((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
            }
        });
    }

    public boolean canFertilize(IAgriFertilizable target) {
        if (!(target instanceof AgriCrop)) {
            return false;
        }
        AgriCrop crop = (AgriCrop)target;
        return crop.hasPlant() && this.affects(new ResourceLocation(crop.getPlantId()));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AgriFertilizer that = (AgriFertilizer)obj;
        return Objects.equals(this.mods, that.mods) && Objects.equals(this.variants, that.variants) && this.triggerMutation == that.triggerMutation && this.triggerWeeds == that.triggerWeeds && this.potency == that.potency && this.reduceGrowth == that.reduceGrowth && this.killPlant == that.killPlant && Objects.equals(this.neutralOn, that.neutralOn) && Objects.equals(this.negativeOn, that.negativeOn) && Objects.equals(this.particles, that.particles);
    }

    public int hashCode() {
        return Objects.hash(this.mods, this.variants, this.triggerMutation, this.triggerWeeds, this.potency, this.reduceGrowth, this.killPlant, this.neutralOn, this.negativeOn, this.particles);
    }

    public String toString() {
        return "AgriFertilizer[mods=" + this.mods + ", variants=" + this.variants + ", triggerMutation=" + this.triggerMutation + ", triggerWeeds=" + this.triggerWeeds + ", potency=" + this.potency + ", reduceGrowth=" + this.reduceGrowth + ", killPlant=" + this.killPlant + ", negativelyAffected=" + this.neutralOn + ", positivelyAffected=" + this.negativeOn + ", particles=" + this.particles + "]";
    }

    public static class Builder {
        private List<String> mods = new ArrayList<String>();
        private List<AgriFertilizerVariant> variants = new ArrayList<AgriFertilizerVariant>();
        private boolean triggerMutation = true;
        private boolean triggerWeeds = true;
        private int potency = 1;
        private boolean reduceGrowth = true;
        private boolean killPlant = true;
        private List<ExtraCodecs.TagOrElementLocation> neutralOn = new ArrayList<ExtraCodecs.TagOrElementLocation>();
        private List<ExtraCodecs.TagOrElementLocation> negativeOn = new ArrayList<ExtraCodecs.TagOrElementLocation>();
        private List<AgriFertilizerParticle> particles = new ArrayList<AgriFertilizerParticle>();

        public AgriFertilizer build() {
            return new AgriFertilizer(this.mods, this.variants, this.triggerMutation, this.triggerWeeds, this.potency, this.reduceGrowth, this.killPlant, this.neutralOn, this.negativeOn, this.particles);
        }

        public Builder mods(String ... mods) {
            Collections.addAll(this.mods, mods);
            return this;
        }

        public Builder variants(AgriFertilizerVariant ... variants) {
            Collections.addAll(this.variants, variants);
            return this;
        }

        public Builder triggerMutation(boolean triggerMutation) {
            this.triggerMutation = triggerMutation;
            return this;
        }

        public Builder triggerWeeds(boolean triggerWeeds) {
            this.triggerWeeds = triggerWeeds;
            return this;
        }

        public Builder potency(int potency) {
            this.potency = potency;
            return this;
        }

        public Builder reduceGrowth(boolean reduceGrowth) {
            this.reduceGrowth = reduceGrowth;
            return this;
        }

        public Builder killPlant(boolean killPlant) {
            this.killPlant = killPlant;
            return this;
        }

        public Builder neutralOn(String ... neutralOn) {
            for (String str : neutralOn) {
                this.neutralOn.add(new ExtraCodecs.TagOrElementLocation(new ResourceLocation(str), false));
            }
            return this;
        }

        public Builder neutralOnTag(String ... neutralOn) {
            for (String str : neutralOn) {
                this.neutralOn.add(new ExtraCodecs.TagOrElementLocation(new ResourceLocation(str), true));
            }
            return this;
        }

        public Builder negativeOn(String ... negativeOn) {
            for (String str : negativeOn) {
                this.negativeOn.add(new ExtraCodecs.TagOrElementLocation(new ResourceLocation(str), false));
            }
            return this;
        }

        public Builder negativeOnTag(String ... negativeOn) {
            for (String str : negativeOn) {
                this.negativeOn.add(new ExtraCodecs.TagOrElementLocation(new ResourceLocation(str), true));
            }
            return this;
        }

        public Builder particles(AgriFertilizerParticle ... particles) {
            Collections.addAll(this.particles, particles);
            return this;
        }
    }
}

