/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.codecs;

import com.agricraft.agricraft.common.util.Platform;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record AgriSeed(ExtraCodecs.TagOrElementLocation item, boolean overridePlanting, CompoundTag nbt, double grassDropChance, double seedDropChance, double seedDropBonus) {
    public static final Codec<AgriSeed> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_216161_.fieldOf("item").forGetter(seed -> seed.item), (App)Codec.BOOL.fieldOf("override_planting").forGetter(seed -> seed.overridePlanting), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(seed -> seed.nbt.m_128456_() ? Optional.empty() : Optional.of(seed.nbt)), (App)Codec.DOUBLE.fieldOf("grass_drop_chance").forGetter(plant -> plant.grassDropChance), (App)Codec.DOUBLE.fieldOf("seed_drop_bonus").forGetter(plant -> plant.seedDropBonus), (App)Codec.DOUBLE.fieldOf("seed_drop_chance").forGetter(plant -> plant.seedDropChance)).apply((Applicative)instance, AgriSeed::new));

    public AgriSeed(ExtraCodecs.TagOrElementLocation item, boolean overridePlanting, Optional<CompoundTag> nbt, double grassDropChance, double seedDropChance, double seedDropBonus) {
        this(item, overridePlanting, nbt.orElse(new CompoundTag()), grassDropChance, seedDropChance, seedDropBonus);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isVariant(ItemStack itemStack) {
        List<Item> items = Platform.get().getItemsFromLocation(this.item());
        if (items.contains(itemStack.m_41720_())) {
            if (this.nbt.m_128456_()) {
                return true;
            }
            CompoundTag tag = itemStack.m_41784_();
            for (String key : this.nbt.m_128431_()) {
                if (tag.m_128441_(key) && tag.m_128423_(key).equals(this.nbt.m_128423_(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class Builder {
        ExtraCodecs.TagOrElementLocation item;
        boolean overridePlanting = true;
        CompoundTag nbt = new CompoundTag();
        double grassDropChance = 0.0;
        double seedDropChance = 1.0;
        double seedDropBonus = 0.0;

        public AgriSeed build() {
            return new AgriSeed(this.item, this.overridePlanting, this.nbt, this.grassDropChance, this.seedDropChance, this.seedDropBonus);
        }

        public Builder item(String location) {
            this.item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(location), false);
            return this;
        }

        public Builder item(String namespace, String path) {
            this.item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(namespace, path), false);
            return this;
        }

        public Builder tag(String location) {
            this.item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(location), true);
            return this;
        }

        public Builder tag(String namespace, String path) {
            this.item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(namespace, path), true);
            return this;
        }

        public Builder nbt(CompoundTag nbt) {
            this.nbt = nbt;
            return this;
        }

        public Builder chances(double grass, double seed, double seedBonus) {
            this.grassDropChance = grass;
            this.seedDropChance = seed;
            this.seedDropBonus = seedBonus;
            return this;
        }

        public Builder overridePlanting(boolean overridePlanting) {
            this.overridePlanting = overridePlanting;
            return this;
        }
    }
}

