/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;

public record AgriProduct(ExtraCodecs.TagOrElementLocation item, CompoundTag nbt, int min, int max, double chance, boolean required) {
    public static final Codec<AgriProduct> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_216161_.fieldOf("item").forGetter(product -> product.item), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(product -> product.nbt.m_128456_() ? Optional.empty() : Optional.of(product.nbt)), (App)Codec.INT.fieldOf("min").forGetter(product -> product.min), (App)Codec.INT.fieldOf("max").forGetter(product -> product.max), (App)Codec.DOUBLE.fieldOf("chance").forGetter(product -> product.chance), (App)Codec.BOOL.fieldOf("required").forGetter(product -> product.required)).apply((Applicative)instance, AgriProduct::new));

    public AgriProduct(ExtraCodecs.TagOrElementLocation item, Optional<CompoundTag> nbt, int min, int max, double chance, boolean required) {
        this(item, nbt.orElse(new CompoundTag()), min, max, chance, required);
    }

    public boolean shouldDrop(RandomSource random) {
        return this.chance > random.m_188500_();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getAmount(RandomSource random) {
        return random.m_216332_(this.min, this.max);
    }

    public static class Builder {
        ExtraCodecs.TagOrElementLocation item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation("minecraft", "air"), false);
        CompoundTag nbt = new CompoundTag();
        int min = 1;
        int max = 3;
        double chance = 0.95;
        boolean required = true;

        public AgriProduct build() {
            return new AgriProduct(this.item, this.nbt, this.min, this.max, this.chance, this.required);
        }

        public Builder item(String location) {
            this.item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(location), false);
            return this;
        }

        public Builder item(String namespace, String path) {
            this.item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(namespace, path), false);
            return this;
        }

        public Builder tag(String location) {
            this.item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(location), true);
            return this;
        }

        public Builder tag(String namespace, String path) {
            this.item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(namespace, path), true);
            return this;
        }

        public Builder nbt(CompoundTag nbt) {
            this.nbt = nbt;
            return this;
        }

        public Builder count(int min, int max, double chance) {
            this.min = min;
            this.max = max;
            this.chance = chance;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }
    }
}

