/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.event;

import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerCache;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerTarget;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TooltipEvents {
    private static final ChatFormatting DESCRIPTION_FORMAT = ChatFormatting.BLUE;
    private static final Component ENHANCER_COMPONENT = Component.m_237115_((String)"item.forbidden_arcanus.enhancer").m_130940_(ChatFormatting.GOLD);

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        EnhancerCache.get(stack.m_41720_()).ifPresent(definition -> {
            List tooltip = event.getToolTip();
            boolean advanced = event.getFlags().m_7050_();
            this.expandTooltip(advanced, tooltip, ENHANCER_COMPONENT);
            this.expandTooltip(advanced, tooltip, CommonComponents.f_237098_);
            for (Map.Entry<EnhancerTarget, Component> test : definition.description().entrySet()) {
                this.expandTooltip(advanced, tooltip, test.getKey().getTitle());
                this.expandTooltip(advanced, tooltip, (Component)Component.m_237113_((String)" ").m_7220_(test.getValue()).m_130940_(DESCRIPTION_FORMAT));
            }
        });
    }

    private void expandTooltip(boolean advanced, List<Component> tooltip, Component addition) {
        if (advanced) {
            tooltip.add(tooltip.size() - 1, addition);
        } else {
            tooltip.add(addition);
        }
    }
}

