/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.network.message.client;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.network.message.NetworkMessageRecord;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record SyncMobCaptureCardDefinitionsMessage(Map<ResourceLocation, MobCaptureCardDefinition> definitions) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_mob_farm", "sync_mob_capture_card_definitions");

    public static SyncMobCaptureCardDefinitionsMessage create(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        HashMap<ResourceLocation, MobCaptureCardDefinition> definitions = new HashMap<ResourceLocation, MobCaptureCardDefinition>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation entityId = buffer.m_130281_();
            MobCaptureCardDefinition definition = MobCaptureCardDefinition.decode(buffer);
            definitions.put(entityId, definition);
        }
        return new SyncMobCaptureCardDefinitionsMessage(definitions);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.definitions.size());
        for (Map.Entry<ResourceLocation, MobCaptureCardDefinition> entry : this.definitions.entrySet()) {
            buffer.m_130085_(entry.getKey());
            entry.getValue().encode(buffer);
        }
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleClient() {
        if (this.definitions == null || this.definitions.isEmpty()) {
            log.warn("No mob capture card definitions to sync!");
            return;
        }
        log.info("Syncing {} mob capture card definitions to client.", (Object)this.definitions.size());
        MobCaptureCardDefinitionManager.setDefinitions(this.definitions);
    }
}

