/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.config.MobFarmConfig;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class MobFarmBlockItem
extends BlockItem {
    public static final String CUSTOM_MODEL_DATA_TAG = "CustomModelData";
    private final String farmName;

    public MobFarmBlockItem(String farmName, Block block) {
        this(farmName, block, new Item.Properties());
    }

    public MobFarmBlockItem(String farmName, Block block, Item.Properties properties) {
        super(block, properties);
        this.farmName = farmName;
    }

    public static void setTierLevel(ItemStack itemStack, int tierLevel) {
        itemStack.m_41784_().m_128405_("TierLevel", tierLevel);
        MobFarmBlockItem.setCustomModelData(itemStack);
    }

    private static void setCustomModelData(ItemStack itemStack) {
        int tierLevel;
        CompoundTag tag = itemStack.m_41784_();
        if (tag.m_128441_("TierLevel") && !tag.m_128441_(CUSTOM_MODEL_DATA_TAG) && (tierLevel = tag.m_128451_("TierLevel")) > 0) {
            tag.m_128405_(CUSTOM_MODEL_DATA_TAG, tierLevel);
        }
    }

    public Component m_7626_(ItemStack stack) {
        int tierLevel = stack.m_41784_().m_128451_("TierLevel");
        return TextComponent.getTranslatedBlockText(this.farmName, tierLevel);
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        super.m_7836_(stack, level, player);
        MobFarmBlockItem.setCustomModelData(stack);
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltip, TooltipFlag flag) {
        MutableComponent processingSpeedText;
        MutableComponent tierLevelText;
        super.m_7373_(itemStack, level, tooltip, flag);
        MutableComponent farmDescription = TextComponent.getTranslatedText(this.farmName);
        List lines = Minecraft.m_91087_().f_91062_.m_92865_().m_92432_(farmDescription.getString(), 200, Style.f_131099_);
        for (FormattedText line : lines) {
            tooltip.add((Component)TextComponent.getText(line.getString()).m_130940_(ChatFormatting.GRAY));
        }
        int tierLevel = itemStack.m_41784_().m_128451_("TierLevel");
        switch (tierLevel) {
            case 0: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level", tierLevel, ChatFormatting.WHITE);
                break;
            }
            case 1: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level", tierLevel, ChatFormatting.GREEN);
                break;
            }
            case 2: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level", tierLevel, ChatFormatting.YELLOW);
                break;
            }
            case 3: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level", tierLevel, ChatFormatting.RED);
                break;
            }
            default: {
                MutableComponent mutableComponent = tierLevelText = null;
            }
        }
        if (tierLevelText != null) {
            tooltip.add((Component)tierLevelText);
        }
        switch (tierLevel) {
            case 0: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), ChatFormatting.WHITE);
                break;
            }
            case 1: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), ChatFormatting.GREEN);
                break;
            }
            case 2: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), ChatFormatting.YELLOW);
                break;
            }
            case 3: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), ChatFormatting.RED);
                break;
            }
            default: {
                MutableComponent mutableComponent = processingSpeedText = null;
            }
        }
        if (processingSpeedText != null) {
            tooltip.add((Component)processingSpeedText);
        }
        if (Objects.equals(this.farmName, MobFarmType.LUCKY_DROP_FARM.getId())) {
            tooltip.add((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.lucky_drop_percentage", new Object[]{MobFarmConfig.luckyDropFarmLuckPercentage}).m_130940_(ChatFormatting.DARK_GREEN));
            if (MobFarmConfig.luckyDropFarmLuckPercentage < 100) {
                tooltip.add((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.lucky_drop_warn").m_130940_(ChatFormatting.RED));
            }
        }
    }
}

