/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.entity;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.config.MobCaptureCardConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FishingEvents {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Random RANDOM = new Random();

    private FishingEvents() {
    }

    public static void handleItemFishedEvent(ServerPlayer serverPlayer, List<ItemStack> lootList) {
        if (!MobCaptureCardConfig.dropMobCaptureCardOnFishing) {
            return;
        }
        Item fishLoot = null;
        for (ItemStack itemStack : lootList) {
            if (itemStack.m_41619_() || !itemStack.m_204117_(ItemTags.f_13156_)) continue;
            fishLoot = itemStack.m_41720_();
            break;
        }
        if (fishLoot == null) {
            return;
        }
        ResourceLocation resourceLocation = BuiltInRegistries.f_257033_.m_7981_(fishLoot);
        EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(resourceLocation);
        if (entityType == null) {
            return;
        }
        String entityName = BuiltInRegistries.f_256780_.m_7981_((Object)entityType).toString();
        if (MobCaptureCardConfig.mobCaptureCardFishingDropDenyList.contains(entityName) || !MobCaptureCardConfig.mobCaptureCardFishingDropAllowList.isEmpty() && !MobCaptureCardConfig.mobCaptureCardFishingDropAllowList.contains(entityName)) {
            log.debug("[Skip] Mob capture card fishing drop for {}.", (Object)entityName);
            return;
        }
        if (MobCaptureCardConfig.mobCaptureCardFishingDropChance > 0.0f && RANDOM.nextFloat() > MobCaptureCardConfig.mobCaptureCardFishingDropChance) {
            return;
        }
        ItemStack itemStack = MobCaptureManager.getMobCaptureCardItem(entityType, serverPlayer.m_9236_());
        if (itemStack != null) {
            log.debug("Dropped mob capture card {} for {}.", (Object)itemStack, (Object)entityType);
            serverPlayer.m_5552_(itemStack, 0.5f);
        } else {
            log.error("Failed to drop mob capture card for {}.", (Object)entityType);
        }
    }
}

