/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.event;

import de.markusbordihn.easymobfarm.client.model.ModelManager;
import de.markusbordihn.easymobfarm.client.model.ModelManagerInterface;
import de.markusbordihn.easymobfarm.client.model.UnbakedMobCaptureCardModel;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModelEventHandler {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static BakedModel mobCaptureCardItemBakedModel;

    private ModelEventHandler() {
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelEvent.RegisterAdditional event) {
        log.info("Registering card models ...");
        Set.of(UnbakedMobCaptureCardModel.MODEL, ModelManagerInterface.DEFAULT_MODEL, ModelManagerInterface.DEFAULT_UNCOMMON_MODEL, ModelManagerInterface.DEFAULT_RARE_MODEL, ModelManagerInterface.DEFAULT_EPIC_MODEL, ModelManagerInterface.DEFAULT_FISH_MODEL).forEach(resourceLocation -> {
            if (resourceLocation instanceof ModelResourceLocation) {
                ModelResourceLocation modelResourceLocation = (ModelResourceLocation)resourceLocation;
                resourceLocation = ModelManager.getRegistrationModelResourceLocation(modelResourceLocation);
            }
            log.info("Registering default model {} ...", resourceLocation);
            event.register(resourceLocation);
        });
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        for (ResourceLocation location : resourceManager.m_214159_("models/item/easy_mob_farm/mob_capture_card", resourceLocation -> resourceLocation.m_135815_().endsWith(".json")).keySet()) {
            ModelResourceLocation modelResourceLocation = ModelManagerInterface.getModelResourceLocation(location);
            log.info("Automatically registering model {} as {} ...", (Object)location, (Object)modelResourceLocation);
            event.register((ResourceLocation)modelResourceLocation);
        }
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.BakingCompleted event) {
        ModelResourceLocation mobCaptureCardModelResourceLocation = new ModelResourceLocation(new ResourceLocation("easy_mob_farm", "mob_capture_card"), "inventory");
        UnbakedMobCaptureCardModel unbakedModel = new UnbakedMobCaptureCardModel(event.getModelBakery().m_119341_(UnbakedMobCaptureCardModel.MODEL));
        log.info("Baking unbaked model for {} ...", (Object)mobCaptureCardModelResourceLocation);
        ModelBakery.ModelBakerImpl baker = new ModelBakery.ModelBakerImpl(event.getModelBakery(), (modelLocation, material) -> material.m_119204_(), (ResourceLocation)mobCaptureCardModelResourceLocation);
        BakedModel bakedModel = unbakedModel.m_7611_((ModelBaker)baker, Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, (ResourceLocation)mobCaptureCardModelResourceLocation);
        event.getModelBakery().m_119251_().put(mobCaptureCardModelResourceLocation, bakedModel);
    }

    public static ModelResourceLocation getModelResourceLocation(ResourceLocation fileLocation) {
        String modelPath = fileLocation.m_135815_().replaceFirst("^models/item/", "").replaceAll("\\.json$", "");
        return new ModelResourceLocation(new ResourceLocation(fileLocation.m_135827_(), modelPath), "inventory");
    }
}

