/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.events;

import dev.xkmc.l2artifacts.content.config.ArtifactSetConfig;
import dev.xkmc.l2artifacts.content.core.BaseArtifact;
import dev.xkmc.l2artifacts.content.effects.core.SetEffect;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod.EventBusSubscriber(modid="l2artifacts", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArtifactEffectEvents {
    public static <T> void postEvent(LivingEntity entity, T event, EventConsumer<T> cons) {
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)entity).resolve();
        if (opt.isEmpty()) {
            return;
        }
        List list = ((ICuriosItemHandler)opt.get()).findCurios(stack -> stack.m_41720_() instanceof BaseArtifact);
        for (SlotResult result : list) {
            ItemStack stack2 = result.stack();
            BaseArtifact base = (BaseArtifact)stack2.m_41720_();
            base.set.get().propagateEvent(result.slotContext(), event, cons);
        }
    }

    public static <T> boolean postEvent(LivingEntity entity, T event, EventPredicate<T> cons) {
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)entity).resolve();
        if (opt.isEmpty()) {
            return false;
        }
        List list = ((ICuriosItemHandler)opt.get()).findCurios(stack -> stack.m_41720_() instanceof BaseArtifact);
        boolean ans = false;
        for (SlotResult result : list) {
            ItemStack stack2 = result.stack();
            BaseArtifact base = (BaseArtifact)stack2.m_41720_();
            ans |= base.set.get().propagateEvent(result.slotContext(), event, cons);
        }
        return ans;
    }

    @SubscribeEvent
    public static void onKillEvent(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity player = (LivingEntity)entity;
            ArtifactEffectEvents.postEvent(player, event, SetEffect::playerKillOpponentEvent);
        }
    }

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent event) {
        ArtifactEffectEvents.postEvent(event.getEntity(), event, SetEffect::playerShieldBlock);
    }

    public static interface EventConsumer<T> {
        public void apply(SetEffect var1, LivingEntity var2, ArtifactSetConfig.Entry var3, int var4, T var5);
    }

    public static interface EventPredicate<T> {
        public boolean apply(SetEffect var1, LivingEntity var2, ArtifactSetConfig.Entry var3, int var4, T var5);
    }
}

