/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.swap;

import dev.xkmc.l2artifacts.content.core.ArtifactSlot;
import dev.xkmc.l2artifacts.content.core.BaseArtifact;
import dev.xkmc.l2artifacts.init.registrate.ArtifactTypeRegistry;
import dev.xkmc.l2serial.serialization.SerialClass;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosCapability;

@SerialClass
public class ArtifactSwapData {
    @SerialClass.SerialField
    public final SwapSlot[] contents = new SwapSlot[45];
    @SerialClass.SerialField
    public int select = 0;

    public ArtifactSwapData() {
        int slot_ind = 0;
        for (ArtifactSlot slot : ArtifactTypeRegistry.SLOT.get()) {
            for (int set_ind = 0; set_ind < 9; ++set_ind) {
                this.contents[set_ind + slot_ind * 9] = new SwapSlot(slot);
            }
            ++slot_ind;
        }
    }

    @SerialClass.OnInject
    public void onInject() {
        int slot_ind = 0;
        for (ArtifactSlot slot : ArtifactTypeRegistry.SLOT.get()) {
            for (int set_ind = 0; set_ind < 9; ++set_ind) {
                this.contents[set_ind + slot_ind * 9].slot = slot;
            }
            ++slot_ind;
        }
    }

    public void swap(Player player) {
        player.getCapability(CuriosCapability.INVENTORY).resolve().ifPresent(cap -> {
            for (int slot_ind = 0; slot_ind < 5; ++slot_ind) {
                SwapSlot slot = this.contents[slot_ind * 9 + this.select];
                if (slot.disabled) continue;
                cap.getStacksHandler(slot.slot.getCurioIdentifier()).ifPresent(h -> {
                    ItemStack old = h.getStacks().getStackInSlot(0);
                    ItemStack store = slot.getStack();
                    if (old.m_41619_()) {
                        if (!store.m_41619_()) {
                            h.getStacks().setStackInSlot(0, store);
                            slot.setStack(ItemStack.f_41583_);
                        }
                    } else if (old.m_41720_() instanceof BaseArtifact) {
                        slot.setStack(old.m_41777_());
                        h.getStacks().setStackInSlot(0, store);
                    }
                });
            }
        });
    }

    @SerialClass
    public static class SwapSlot {
        public ArtifactSlot slot;
        @SerialClass.SerialField
        private ItemStack stack = ItemStack.f_41583_;
        @SerialClass.SerialField
        private boolean disabled = false;

        @Deprecated
        public SwapSlot() {
        }

        public SwapSlot(ArtifactSlot slot) {
            this.slot = slot;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack item) {
            this.stack = item;
            if (this.disabled && !item.m_41619_()) {
                this.disabled = false;
            }
        }

        public void toggle() {
            if (this.stack.m_41619_()) {
                this.disabled = !this.disabled;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canAccept(ItemStack st) {
            if (this.disabled) return false;
            Item item = st.m_41720_();
            if (!(item instanceof BaseArtifact)) return false;
            BaseArtifact a = (BaseArtifact)item;
            if (a.slot.get() != this.slot) return false;
            return true;
        }

        public boolean isLocked() {
            return this.disabled;
        }
    }
}

