/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.search.token;

import dev.xkmc.l2artifacts.content.core.BaseArtifact;
import dev.xkmc.l2artifacts.content.search.token.IArtifactFeature;
import dev.xkmc.l2artifacts.content.search.token.IArtifactFilter;
import dev.xkmc.l2artifacts.content.search.token.IArtifactPredicate;
import dev.xkmc.l2artifacts.init.data.LangData;
import dev.xkmc.l2library.util.code.GenericItemStack;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

@SerialClass
public abstract class ArtifactFilter<T extends IArtifactFeature>
implements IArtifactFilter {
    public final List<T> allEntries;
    protected final Map<T, Integer> revMap = new HashMap<T, Integer>();
    private final IArtifactFilter parent;
    private final IArtifactPredicate<T> func;
    private final LangData desc;
    @SerialClass.SerialField
    private boolean[] selected;
    @SerialClass.SerialField
    protected int[] item_priority;
    @SerialClass.SerialField
    protected int sort_priority;
    @Nullable
    private boolean[] availability;

    public ArtifactFilter(IArtifactFilter parent, LangData desc, Collection<T> reg, IArtifactPredicate<T> func) {
        int n;
        this.parent = parent;
        if (parent instanceof ArtifactFilter) {
            ArtifactFilter a = (ArtifactFilter)parent;
            n = a.sort_priority + 1;
        } else {
            n = 1;
        }
        this.sort_priority = n;
        this.allEntries = new ArrayList<T>(reg);
        this.func = func;
        this.desc = desc;
        this.selected = new boolean[this.allEntries.size()];
        this.item_priority = new int[this.allEntries.size()];
        for (int i = 0; i < this.allEntries.size(); ++i) {
            this.selected[i] = true;
            this.item_priority[i] = i + 1;
            this.revMap.put((IArtifactFeature)this.allEntries.get(i), i);
        }
    }

    public void toggle(int ind) {
        int n = ind;
        this.selected[n] = this.selected[n] ^ true;
        if (this.selected[ind]) {
            this.prioritize(ind);
        } else {
            this.item_priority[ind] = 0;
        }
        this.update();
    }

    public void prioritize(int ind) {
        int i;
        this.item_priority[ind] = 0;
        ArrayList<IArtifactFeature> list = new ArrayList<IArtifactFeature>(this.allEntries.stream().filter(e -> this.selected[this.revMap.get(e)]).toList());
        list.sort(Comparator.comparingInt(e -> this.item_priority[this.revMap.get(e)]));
        for (i = 0; i < this.allEntries.size(); ++i) {
            this.item_priority[i] = 0;
        }
        for (i = 0; i < list.size(); ++i) {
            this.item_priority[this.revMap.get(list.get((int)i)).intValue()] = i + 1;
        }
    }

    public boolean getSelected(int i) {
        return this.selected[i];
    }

    public boolean getAvailability(int j) {
        if (this.availability != null) {
            return this.availability[j];
        }
        this.availability = new boolean[this.allEntries.size()];
        List<GenericItemStack<BaseArtifact>> list = this.parent.getAvailableArtifacts().toList();
        for (int i = 0; i < this.allEntries.size(); ++i) {
            int I = i;
            this.availability[i] = list.stream().anyMatch(e -> this.func.test((GenericItemStack<BaseArtifact>)e, (IArtifactFeature)this.allEntries.get(I)));
        }
        return this.availability[j];
    }

    private boolean isValid(GenericItemStack<BaseArtifact> item) {
        for (int i = 0; i < this.allEntries.size(); ++i) {
            if (!this.selected[i] || !this.func.test(item, (IArtifactFeature)this.allEntries.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public void update() {
        this.parent.update();
    }

    protected void clearCache() {
        this.availability = null;
    }

    @Override
    public Stream<GenericItemStack<BaseArtifact>> getAvailableArtifacts() {
        return this.parent.getAvailableArtifacts().filter(this::isValid);
    }

    public Component getDescription() {
        return this.desc.get(new Object[0]).m_130940_(ChatFormatting.GRAY);
    }

    public int getPriority(int j) {
        return this.item_priority[j];
    }

    public int priority() {
        return this.sort_priority;
    }

    @SerialClass.OnInject
    public void postInject() {
        int size = this.allEntries.size();
        if (this.item_priority.length < size) {
            this.item_priority = Arrays.copyOf(this.item_priority, size);
        }
        if (this.selected.length < size) {
            this.selected = Arrays.copyOf(this.selected, size);
        }
    }
}

