/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.search.fitered;

import dev.xkmc.l2artifacts.content.core.BaseArtifact;
import dev.xkmc.l2artifacts.content.misc.RandomArtifactItem;
import dev.xkmc.l2artifacts.content.search.common.AbstractScrollerMenu;
import dev.xkmc.l2artifacts.content.search.token.ArtifactChestToken;
import dev.xkmc.l2artifacts.init.data.ArtifactConfig;
import dev.xkmc.l2artifacts.init.registrate.ArtifactMenuRegistry;
import dev.xkmc.l2artifacts.init.registrate.items.ArtifactItems;
import dev.xkmc.l2library.base.menu.base.SpriteManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FilteredMenu
extends AbstractScrollerMenu<FilteredMenu> {
    private static final SpriteManager MANAGER = new SpriteManager("l2artifacts", "filtered");
    private ItemStack selected = ItemStack.f_41583_;

    public static FilteredMenu fromNetwork(MenuType<FilteredMenu> type, int wid, Inventory plInv, FriendlyByteBuf buf) {
        int i = buf.readInt();
        return new FilteredMenu(wid, plInv, ArtifactChestToken.of(plInv.f_35978_, i));
    }

    public FilteredMenu(int wid, Inventory plInv, ArtifactChestToken token) {
        super((MenuType)ArtifactMenuRegistry.MT_FILTER.get(), wid, plInv, MANAGER, 2, token, false);
        this.addSlot("input", e -> token.list.size() < this.getMaxSize() && (e.m_41720_() instanceof BaseArtifact || e.m_41720_() instanceof RandomArtifactItem));
        this.addSlot("output", e -> false);
        this.addSlot("grid", e -> false, e -> e.setPickup(() -> false));
        this.reload(true);
    }

    private int getMaxSize() {
        return this.token.stack.m_41720_() == ArtifactItems.FILTER.get() ? (Integer)ArtifactConfig.COMMON.storageSmall.get() : (Integer)ArtifactConfig.COMMON.storageLarge.get();
    }

    @Override
    protected void clickSlot(int slot) {
        this.selected = this.token.getFiltered().get(slot).stack();
        this.container.m_6836_(1, this.selected.m_41777_());
    }

    @Override
    public void m_6199_(Container cont) {
        if (!this.player.m_9236_().m_5776_()) {
            if (!cont.m_8020_(0).m_41619_()) {
                ItemStack stack = cont.m_8020_(0).m_41777_();
                Item item = stack.m_41720_();
                if (item instanceof RandomArtifactItem) {
                    RandomArtifactItem item2 = (RandomArtifactItem)item;
                    for (int i = 0; i < stack.m_41613_(); ++i) {
                        this.addItemToList(RandomArtifactItem.getRandomArtifact(stack, item2.rank, this.player.m_217043_()));
                    }
                } else {
                    this.addItemToList(stack);
                }
                cont.m_6836_(0, ItemStack.f_41583_);
                this.token.update();
                this.token.save();
                this.selected = ItemStack.f_41583_;
                this.container.m_6836_(1, this.selected);
                this.reload(true);
            }
            if (!this.selected.m_41619_() && cont.m_8020_(1).m_41619_()) {
                this.removeSelected();
            }
        }
        super.m_6199_(cont);
    }

    private void addItemToList(ItemStack stack) {
        stack = (ItemStack)((BaseArtifact)stack.m_41720_()).resolve(stack, false, this.player.m_217043_()).m_19095_();
        this.token.list.add(stack);
    }

    private void removeSelected() {
        this.token.list.remove(this.selected);
        this.token.update();
        this.token.save();
        this.selected = ItemStack.f_41583_;
        this.reload(true);
    }
}

