/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.effects.v2;

import dev.xkmc.l2artifacts.content.config.ArtifactSetConfig;
import dev.xkmc.l2artifacts.content.effects.core.SetEffect;
import dev.xkmc.l2artifacts.init.registrate.entries.LinearFuncEntry;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2library.base.effects.EffectUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class FrozeSlowEffect
extends SetEffect {
    private final LinearFuncEntry factor;
    private final LinearFuncEntry period;
    private final LinearFuncEntry level;

    public FrozeSlowEffect(LinearFuncEntry factor, LinearFuncEntry period, LinearFuncEntry level) {
        super(0);
        this.factor = factor;
        this.period = period;
        this.level = level;
    }

    @Override
    public void playerHurtOpponentEvent(LivingEntity player, ArtifactSetConfig.Entry ent, int rank, AttackCache event) {
        if (player.m_6060_()) {
            return;
        }
        EffectUtil.addEffect((LivingEntity)event.getAttackTarget(), (MobEffectInstance)new MobEffectInstance(MobEffects.f_19597_, (int)this.period.getFromRank(rank), (int)this.level.getFromRank(rank)), (EffectUtil.AddReason)EffectUtil.AddReason.NONE, (Entity)player);
    }

    @Override
    public List<MutableComponent> getDetailedDescription(int rank) {
        double dmg = this.factor.getFromRank(rank) * 100.0;
        double period = this.period.getFromRank(rank) / 20.0;
        MutableComponent level = Component.m_237115_((String)("potion.potency." + (int)this.level.getFromRank(rank)));
        return List.of(Component.m_237110_((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{(int)Math.round(dmg), level, period}));
    }

    @Override
    public void playerReduceDamage(LivingEntity player, ArtifactSetConfig.Entry ent, int rank, DamageSource source, AttackCache cache) {
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            cache.addDealtModifier(DamageModifier.multTotal((float)((float)this.factor.getFromRank(rank))));
        }
    }
}

