/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.effects.attribute;

import dev.xkmc.l2artifacts.content.config.ArtifactSetConfig;
import dev.xkmc.l2artifacts.content.effects.attribute.AttrSetEntry;
import dev.xkmc.l2artifacts.content.effects.attribute.AttributeSetData;
import dev.xkmc.l2artifacts.content.effects.core.PersistentDataSetEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractConditionalAttributeSetEffect<T extends AttributeSetData>
extends PersistentDataSetEffect<T> {
    private final AttrSetEntry[] entries;

    public AbstractConditionalAttributeSetEffect(AttrSetEntry ... entries) {
        super(entries.length);
        this.entries = entries;
    }

    protected void addAttributes(Player player, ArtifactSetConfig.Entry ent, int rank, T data) {
        for (int i = 0; i < this.entries.length; ++i) {
            UUID id;
            AttrSetEntry entry = this.entries[i];
            AttributeInstance ins = player.m_21051_(entry.attr().get());
            if (ins == null || ins.m_22111_(id = ent.id[i]) != null) continue;
            double val = entry.getValue(rank);
            ins.m_22118_(new AttributeModifier(id, ent.getName(), val, entry.op()));
        }
    }

    protected abstract T getData();

    @Override
    public T getData(ArtifactSetConfig.Entry ent) {
        T ans = this.getData();
        for (int i = 0; i < this.entries.length; ++i) {
            AttrSetEntry entry = this.entries[i];
            UUID id = ent.id[i];
            ((AttributeSetData)((Object)ans)).list.add(new AttributeSetData.AttributePair(entry.attr().get(), id));
        }
        return ans;
    }

    protected MutableComponent getConditionText(int rank) {
        return Component.m_237115_((String)(this.getDescriptionId() + ".desc"));
    }

    @Override
    public List<MutableComponent> getDetailedDescription(int rank) {
        ArrayList<MutableComponent> ans = new ArrayList<MutableComponent>();
        ans.add(this.getConditionText(rank));
        for (AttrSetEntry ent : this.entries) {
            double val = ent.getValue(rank);
            String sign = val > 0.0 ? "attribute.modifier.plus." : "attribute.modifier.take.";
            ans.add(Component.m_237110_((String)(sign + (ent.usePercent() ? 1 : 0)), (Object[])new Object[]{ItemStack.f_41584_.format(Math.abs(ent.usePercent() ? val * 100.0 : val)), Component.m_237115_((String)ent.attr().get().m_22087_())}));
        }
        return ans;
    }
}

