/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.config;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import dev.xkmc.l2artifacts.content.core.ArtifactSet;
import dev.xkmc.l2artifacts.content.effects.core.SetEffect;
import dev.xkmc.l2artifacts.network.NetworkManager;
import dev.xkmc.l2library.capability.conditionals.Context;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2library.serial.config.CollectType;
import dev.xkmc.l2library.serial.config.ConfigCollect;
import dev.xkmc.l2library.util.math.MathHelper;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

@SerialClass
public class ArtifactSetConfig
extends BaseConfig {
    @ConfigCollect(value=CollectType.MAP_COLLECT)
    @SerialClass.SerialField
    public HashMap<ArtifactSet, ArrayList<Entry>> map = new HashMap();

    public static ArtifactSetConfig getInstance() {
        return (ArtifactSetConfig)NetworkManager.ARTIFACT_SETS.getMerged();
    }

    public static ArtifactSetConfig construct(ArtifactSet set, Consumer<SetBuilder> builder) {
        ArtifactSetConfig config = new ArtifactSetConfig();
        ArrayList list = new ArrayList();
        builder.accept((count, effect) -> list.add(new Entry(count, effect)));
        config.map.put(set, list);
        return config;
    }

    protected void postMerge() {
        this.map.values().forEach(e -> e.sort(null));
        this.map.forEach((k, v) -> v.forEach(e -> e.validate((ArtifactSet)k)));
    }

    public static interface SetBuilder {
        public void add_impl(int var1, SetEffect var2);

        default public SetBuilder add(int count, SetEffect effect) {
            this.add_impl(count, effect);
            return this;
        }
    }

    @SerialClass
    public static class Entry
    implements Comparable<Entry>,
    Context {
        @SerialClass.SerialField
        public int count;
        @SerialClass.SerialField
        public SetEffect effect;
        private String name;
        public UUID[] id;

        @Deprecated
        public Entry() {
        }

        Entry(int count, SetEffect effect) {
            this.count = count;
            this.effect = effect;
        }

        @Override
        public int compareTo(@NotNull Entry o) {
            int ans = Integer.compare(this.count, o.count);
            if (ans != 0) {
                return ans;
            }
            return this.effect.getID().compareTo(o.effect.getID());
        }

        public void validate(ArtifactSet set) {
            String str = set.getID() + "_" + this.effect.getID();
            this.name = RegistrateLangProvider.toEnglishName((String)this.effect.getRegistryName().m_135815_());
            this.id = new UUID[this.effect.ids];
            for (int i = 0; i < this.effect.ids; ++i) {
                this.id[i] = MathHelper.getUUIDFromString((String)(str + "_" + i));
            }
        }

        public String getName() {
            return this.name;
        }
    }
}

