/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.level;

import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LevelHelper {
    public static DifficultyInstance getDifficultyAt(Level level, BlockPos position) {
        return level.m_6436_(position);
    }

    public static double getRegionalDifficultyAt(Level level, BlockPos position) {
        return LevelHelper.getDifficultyAt(level, position).m_19056_();
    }

    public static double getClampedRegionalDifficultyAt(Level level, BlockPos position) {
        return LevelHelper.getDifficultyAt(level, position).m_19057_();
    }

    public static boolean isRainingAt(Level level, BlockPos position) {
        return level.m_46758_(position);
    }

    public static boolean isDayAt(Level level) {
        return level.m_46461_();
    }

    public static boolean isNightAt(Level level) {
        return level.m_46462_();
    }

    public static boolean isMobGriefingEnabled(Level level) {
        return level.m_46469_().m_46207_(GameRules.f_46132_);
    }

    public static Optional<SpawnPoint> getSpawnPoint(ServerPlayer player) {
        Vec3 position;
        BlockPos respawnPosition = player.m_8961_();
        ServerLevel level = player.f_8924_.m_129880_(player.m_8963_());
        if (level == null) {
            return Optional.empty();
        }
        if (respawnPosition != null) {
            position = AnyPos.from(respawnPosition).vec3();
        } else {
            level = player.f_8924_.m_129880_(Level.f_46428_);
            position = AnyPos.from(level.m_220360_()).vec3();
        }
        return Optional.of(new SpawnPoint(level, position));
    }

    public static boolean teleportNearby(LivingEntity target, ServerLevel level, double offset) {
        Vec3 position = AnyPos.from(target.m_20182_()).add(Random.nextDouble(-offset, offset), 0.0, Random.nextDouble(-offset, offset)).vec3();
        BlockPos blockPos = LevelHelper.findBlockPosOnGround((Level)level, position, 3).orElse(null);
        if (blockPos != null && target.m_20984_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), true)) {
            SoundEmitter.of(SoundEvents.f_11852_).position(position).emit((Level)level);
            ParticleEmitter.of((ParticleOptions)ParticleTypes.f_123760_).count(10).position(position).emit((Level)level);
            return true;
        }
        return false;
    }

    public static void freezeWater(Entity entity, double radius, int minimumIceDuration, int maximumIceDuration) {
        LevelHelper.freezeWater(entity, radius, minimumIceDuration, maximumIceDuration, true);
    }

    public static void freezeWater(Entity entity, double radius, int minimumIceDuration, int maximumIceDuration, boolean requireOnGround) {
        if (requireOnGround && !entity.m_20096_()) {
            return;
        }
        BlockState iceBlockState = Blocks.f_50449_.m_49966_();
        BlockPos entityPosition = entity.m_20183_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        Iterable blocksInRange = BlockPos.m_121940_((BlockPos)entityPosition.m_7918_((int)(-radius), -1, (int)(-radius)), (BlockPos)entityPosition.m_7918_((int)radius, -1, (int)radius));
        for (BlockPos blockPos : blocksInRange) {
            if (!blockPos.m_123314_((Vec3i)entityPosition, radius)) continue;
            mutableBlockPos.m_122178_(blockPos.m_123341_(), blockPos.m_123342_() + 1, blockPos.m_123343_());
            BlockState blockState = entity.m_9236_().m_8055_((BlockPos)mutableBlockPos);
            if (!blockState.m_60795_()) continue;
            BlockState blockState2 = entity.m_9236_().m_8055_(blockPos);
            boolean meltsIntoFrostedIceBlock = blockState2 == FrostedIceBlock.m_278844_();
            boolean canSurvive = iceBlockState.m_60710_((LevelReader)entity.m_9236_(), blockPos);
            boolean isUnobstructed = entity.m_9236_().m_45752_(iceBlockState, blockPos, CollisionContext.m_82749_());
            if (!meltsIntoFrostedIceBlock || !canSurvive || !isUnobstructed) continue;
            entity.m_9236_().m_46597_(blockPos, iceBlockState);
            entity.m_9236_().m_186460_(blockPos, Blocks.f_50449_, Random.nextInt(minimumIceDuration, maximumIceDuration));
        }
    }

    public static void spawnItemEntityFlyingTowardsDirection(ItemStack itemStack, Level level, Vec3 from, Vec3 to) {
        Vec3 spawnPosition = AnyPos.from(from).add(Random.nextVector(-0.25, 0.25, 0.125, 0.5, -0.25, 0.25)).vec3();
        Vec3 motion = AnyPos.from(to).sub(spawnPosition).mul(0.1).vec3();
        ItemEntity itemEntity = new ItemEntity(level, spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_, itemStack);
        itemEntity.m_20256_(AnyPos.from(motion).add(0.0, Math.pow(AnyPos.from(motion).len().doubleValue(), 0.5) * 0.25, 0.0).vec3());
        level.m_7967_((Entity)itemEntity);
    }

    public static void startRaining(Level level, int ticks, boolean withThunder) {
        LevelData levelData = level.m_6106_();
        if (levelData instanceof ServerLevelData) {
            ServerLevelData data = (ServerLevelData)levelData;
            data.m_5565_(true);
            data.m_6399_(ticks);
            if (withThunder) {
                data.m_5557_(true);
                data.m_6398_(ticks);
            }
            data.m_6393_(0);
        }
    }

    public static void startRaining(Level level, int ticks) {
        LevelHelper.startRaining(level, ticks, false);
    }

    public static void setClearWeather(Level level, int ticks) {
        LevelData levelData = level.m_6106_();
        if (levelData instanceof ServerLevelData) {
            ServerLevelData data = (ServerLevelData)levelData;
            data.m_5565_(false);
            data.m_6399_(0);
            data.m_5557_(false);
            data.m_6398_(0);
            data.m_6393_(ticks);
        }
    }

    public static <Type extends Number> Optional<BlockPos> findBlockPosOnGround(Level level, Vec3 position, Type yOffset) {
        return LevelHelper.findBlockPosOnGround(level, position.f_82479_, Range.of(position.f_82480_ - yOffset.doubleValue(), position.f_82480_ + yOffset.doubleValue()), position.f_82481_);
    }

    public static <Type extends Number> Optional<BlockPos> findBlockPosOnGround(Level level, Type x, Range<Type> y, Type z) {
        BlockPos blockPos = AnyPos.from(x, y.to, z).block();
        do {
            BlockPos blockPosBelow;
            BlockState blockStateBelow;
            if (!(blockStateBelow = level.m_8055_(blockPosBelow = blockPos.m_7495_())).m_60783_((BlockGetter)level, blockPosBelow, Direction.UP)) continue;
            if (!level.m_46859_(blockPos)) {
                BlockState blockState = level.m_8055_(blockPos);
                VoxelShape voxelshape = blockState.m_60812_((BlockGetter)level, blockPos);
                BlockPos blockPosAbove = AnyPos.from(blockPos).add(0, !voxelshape.m_83281_() ? voxelshape.m_83297_(Direction.Axis.Y) : 0.0, 0).block();
                if (!blockState.m_60812_((BlockGetter)level, blockPosAbove).m_83281_()) continue;
                return Optional.of(blockPosAbove);
            }
            return Optional.of(blockPos);
        } while ((blockPos = blockPos.m_7495_()).m_123342_() >= ((Number)y.from).intValue() - 1);
        return Optional.empty();
    }

    public static BlockPos getPositionOverFluid(Level level, BlockPos position) {
        BlockPos offset = new BlockPos((Vec3i)position);
        int y = position.m_123342_();
        while (y++ < level.m_151558_() && !level.m_8055_(offset = AnyPos.from(position.m_123341_(), y, position.m_123343_()).block()).m_60819_().m_76178_()) {
        }
        return offset;
    }

    @Nullable
    public static Player getNearestPlayer(Level level, BlockPos position, float maxDistance) {
        return level.m_45924_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (double)maxDistance, false);
    }

    public static class SpawnPoint {
        public final ServerLevel level;
        public final Vec3 position;

        public SpawnPoint(ServerLevel level, Vec3 position) {
            this.level = level;
            this.position = position;
        }

        public void teleport(ServerPlayer player) {
            float angle = player.m_8962_();
            Optional spawnPosition = Player.m_36130_((ServerLevel)this.level, (BlockPos)AnyPos.from(this.position).block(), (float)angle, (boolean)true, (boolean)true);
            Vec3 position = spawnPosition.orElse(this.position);
            player.m_8999_(this.level, position.f_82479_, position.f_82480_, position.f_82481_, player.m_146908_(), player.m_146909_());
        }
    }
}

