/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.generator;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import java.util.HashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockModelJsonGenerator
extends BlockStateProvider {
    public BlockModelJsonGenerator(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    protected void registerStatesAndModels() {
        HashMap<ResourceLocation, ModelFile[]> stemModels = new HashMap<ResourceLocation, ModelFile[]>();
        for (CropType type : CropRegistry.getInstance().getTypes()) {
            ModelFile[] models = new ModelFile[8];
            ResourceLocation stemModel = type.getStemModel();
            for (int i = 0; i <= 7; ++i) {
                models[i] = new ModelFile.UncheckedModelFile(new ResourceLocation(stemModel.m_135827_(), stemModel.m_135815_() + "_" + i));
            }
            stemModels.put(type.getId(), models);
        }
        for (Crop crop : CropRegistry.getInstance().getCrops()) {
            CropBlock block = crop.getCropBlock();
            ModelFile[] models = (ModelFile[])stemModels.get(crop.getType().getId());
            if (!crop.shouldRegisterCropBlock()) continue;
            this.getVariantBuilder((Block)block).forAllStates(state -> {
                Integer age = (Integer)state.m_61143_((Property)CropBlock.f_52244_);
                if (age.intValue() == block.m_7419_()) {
                    BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(crop.getNameWithSuffix("crop"))).parent(models[7])).texture("flower", crop.getTextures().getFlowerTexture());
                    return ConfiguredModel.builder().modelFile((ModelFile)model).build();
                }
                return ConfiguredModel.builder().modelFile(models[age]).build();
            });
        }
    }

    public String m_6055_() {
        return "Mystical Agriculture block model generator";
    }
}

