/*
 * Decompiled with CFR 0.152.
 */
package com.sn4pe.wishing_wells.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class CustomWorldData
extends SavedData {
    private static final String DATA_NAME = "WishingWellData";
    private final Map<String, Map<String, Integer>> playerWellThrowCounts = new HashMap<String, Map<String, Integer>>();

    public static CustomWorldData get(ServerLevel level) {
        return (CustomWorldData)level.m_8895_().m_164861_(CustomWorldData::load, CustomWorldData::new, DATA_NAME);
    }

    public static CustomWorldData load(CompoundTag tag) {
        CustomWorldData data = new CustomWorldData();
        CompoundTag countsTag = tag.m_128469_("PlayerWellThrowCounts");
        for (String playerKey : countsTag.m_128431_()) {
            CompoundTag playerTag = countsTag.m_128469_(playerKey);
            HashMap<String, Integer> wellCounts = new HashMap<String, Integer>();
            for (String wellKey : playerTag.m_128431_()) {
                wellCounts.put(wellKey, playerTag.m_128451_(wellKey));
            }
            data.playerWellThrowCounts.put(playerKey, wellCounts);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag countsTag = new CompoundTag();
        for (Map.Entry<String, Map<String, Integer>> playerEntry : this.playerWellThrowCounts.entrySet()) {
            CompoundTag playerTag = new CompoundTag();
            for (Map.Entry<String, Integer> wellEntry : playerEntry.getValue().entrySet()) {
                playerTag.m_128405_(wellEntry.getKey(), wellEntry.getValue().intValue());
            }
            countsTag.m_128365_(playerEntry.getKey(), (Tag)playerTag);
        }
        tag.m_128365_("PlayerWellThrowCounts", (Tag)countsTag);
        return tag;
    }

    public int getThrowCount(UUID playerUUID, BlockPos pos) {
        Map wellCounts = this.playerWellThrowCounts.getOrDefault(playerUUID.toString(), new HashMap());
        return wellCounts.getOrDefault(pos.m_123344_(), 0);
    }

    public void incrementThrowCount(UUID playerUUID, BlockPos pos) {
        String playerKey = playerUUID.toString();
        String wellKey = pos.m_123344_();
        this.playerWellThrowCounts.putIfAbsent(playerKey, new HashMap());
        Map<String, Integer> wellCounts = this.playerWellThrowCounts.get(playerKey);
        wellCounts.put(wellKey, wellCounts.getOrDefault(wellKey, 0) + 1);
        this.m_77762_();
    }
}

