/*
 * Decompiled with CFR 0.152.
 */
package com.sn4pe.wishing_wells.curse;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class Curse {
    public static void applyRandomCurse(Player player, ServerLevel level) {
        Random random = new Random();
        int curseIndex = random.nextInt(6);
        switch (curseIndex) {
            case 0: {
                Curse.applyWitherCurse(player, level);
                break;
            }
            case 1: {
                Curse.applyLightningCurse(player, level);
                break;
            }
            case 2: {
                Curse.applyAnvilCurse(player, level);
                break;
            }
            case 3: {
                Curse.applySlownessCurse(player, level);
                break;
            }
            case 4: {
                Curse.applyBlindnessCurse(player, level);
                break;
            }
            case 5: {
                Curse.applyZombieCurse(player, level);
            }
        }
    }

    private static void applyWitherCurse(Player player, ServerLevel level) {
        player.m_213846_((Component)Component.m_237115_((String)"message.curse.wither"));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 600, 1));
    }

    private static void applyLightningCurse(Player player, ServerLevel level) {
        player.m_213846_((Component)Component.m_237115_((String)"message.curse.lightning"));
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
        if (lightningBolt != null) {
            lightningBolt.m_6027_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            level.m_7967_((Entity)lightningBolt);
        }
    }

    private static void applyAnvilCurse(Player player, ServerLevel level) {
        BlockPos playerPos = player.m_20183_().m_6630_(10);
        if (level.m_8055_(playerPos).m_60795_()) {
            player.m_213846_((Component)Component.m_237115_((String)"message.curse.anvil"));
            level.m_46597_(playerPos, Blocks.f_50322_.m_49966_());
        }
    }

    private static void applySlownessCurse(Player player, ServerLevel level) {
        player.m_213846_((Component)Component.m_237115_((String)"message.curse.slowness"));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 600, 2));
    }

    private static void applyBlindnessCurse(Player player, ServerLevel level) {
        player.m_213846_((Component)Component.m_237115_((String)"message.curse.blindness"));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 600, 1));
    }

    private static void applyZombieCurse(Player player, ServerLevel level) {
        Random random = new Random();
        player.m_213846_((Component)Component.m_237115_((String)"message.curse.zombie"));
        for (int i = 0; i < 3; ++i) {
            Zombie zombie = new Zombie(EntityType.f_20501_, (Level)level);
            double xOffset = (double)(i - 1) * 1.5;
            double zOffset = (double)(i - 1) * 1.5;
            BlockPos zombiePos = player.m_20183_().m_7918_((int)xOffset, 0, (int)zOffset);
            zombie.m_6034_((double)zombiePos.m_123341_(), (double)zombiePos.m_123342_(), (double)zombiePos.m_123343_());
            ItemStack goldHelmet = new ItemStack((ItemLike)Items.f_42476_);
            zombie.m_8061_(EquipmentSlot.HEAD, goldHelmet);
            level.m_7967_((Entity)zombie);
            for (int j = 0; j < 20; ++j) {
                double x = (double)zombiePos.m_123341_() + (random.nextDouble() - 0.5) * 2.0;
                double y = (double)zombiePos.m_123342_() + random.nextDouble() * 2.0;
                double z = (double)zombiePos.m_123343_() + (random.nextDouble() - 0.5) * 2.0;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123809_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

