/*
 * Decompiled with CFR 0.152.
 */
package com.sn4pe.wishing_wells.block;

import com.sn4pe.wishing_wells.Config;
import com.sn4pe.wishing_wells.blessing.Blessing;
import com.sn4pe.wishing_wells.curse.Curse;
import com.sn4pe.wishing_wells.data.CustomWorldData;
import com.sn4pe.wishing_wells.data.TossableItem;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SimpleFountainBlock
extends Block {
    public SimpleFountainBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    private int getCurseThreshold() {
        if (Config.curseFixedThreshold >= 0) {
            return Config.curseFixedThreshold;
        }
        Random random = new Random();
        return random.nextInt(Config.curseMaxThreshold - Config.curseMinThreshold + 1) + Config.curseMinThreshold;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        ItemEntity itemEntity;
        TossableItem tossableItem;
        super.m_7892_(state, level, pos, entity);
        if (entity instanceof ItemEntity && (tossableItem = this.getTossableItem((itemEntity = (ItemEntity)entity).m_32055_().m_41720_())) != null) {
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            double itemX = itemEntity.m_20185_();
            double itemY = itemEntity.m_20186_();
            double itemZ = itemEntity.m_20189_();
            AABB aabb = new AABB(pos).m_82400_(5.0);
            level.m_45976_(Player.class, aabb).forEach(player -> {
                if (level instanceof ServerLevel) {
                    CustomWorldData worldData = CustomWorldData.get((ServerLevel)level);
                    worldData.incrementThrowCount(player.m_20148_(), pos);
                    int throwCount = worldData.getThrowCount(player.m_20148_(), pos);
                    int curseThreshold = this.getCurseThreshold();
                    if (throwCount > curseThreshold) {
                        Curse.applyRandomCurse(player, (ServerLevel)level);
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 1.0, 1.0, 1.0, 0.0);
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12563_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else if (this.shouldGrantReward(tossableItem)) {
                        Blessing.applyBlessing(player, (ServerLevel)level, pos, itemX, itemY, itemZ);
                        Blessing.giveRandomReward(player, (ResourceKey<Level>)level.m_46472_());
                    } else {
                        player.m_213846_((Component)Component.m_237115_((String)"message.miss"));
                        if (level instanceof ServerLevel) {
                            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123762_, itemX, itemY, itemZ, 20, 0.5, 0.5, 0.5, 0.0);
                            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                }
            });
        }
    }

    private TossableItem getTossableItem(Item item) {
        for (TossableItem tossableItem : Config.tossableItems) {
            if (tossableItem.getItem() != item) continue;
            return tossableItem;
        }
        return null;
    }

    private boolean shouldGrantReward(TossableItem tossableItem) {
        Random random = new Random();
        return random.nextDouble() < tossableItem.getSuccessProbability();
    }
}

