/*
 * Decompiled with CFR 0.152.
 */
package com.sn4pe.wishing_wells.blessing;

import com.sn4pe.wishing_wells.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public record Blessing(String name, double probability) {
    public void apply(Player player, ServerLevel level, BlockPos pos) {
        switch (this.name) {
            case "blessing:heal": {
                Blessing.applyHealingBlessing(player);
                break;
            }
            case "blessing:speed": {
                Blessing.applySpeedBlessing(player);
                break;
            }
            case "blessing:strength": {
                Blessing.applyStrengthBlessing(player);
                break;
            }
            case "blessing:wolf": {
                Blessing.applyWolfCompanionBlessing(player, level);
                break;
            }
            case "blessing:cat": {
                Blessing.applyCatCompanionBlessing(player, level);
                break;
            }
            case "blessing:experience": {
                Blessing.applyExperienceBlessing(player, level);
                break;
            }
            default: {
                this.giveItemReward(player, level, pos);
            }
        }
    }

    private static void applyHealingBlessing(Player player) {
        player.m_213846_((Component)Component.m_237115_((String)"message.blessing.heal"));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 600, 1));
    }

    private static void applySpeedBlessing(Player player) {
        player.m_213846_((Component)Component.m_237115_((String)"message.blessing.speed"));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 1));
    }

    private static void applyStrengthBlessing(Player player) {
        player.m_213846_((Component)Component.m_237115_((String)"message.blessing.strength"));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600, 1));
    }

    private static void applyWolfCompanionBlessing(Player player, ServerLevel level) {
        player.m_213846_((Component)Component.m_237115_((String)"message.blessing.wolf"));
        Wolf wolf = new Wolf(EntityType.f_20499_, (Level)level);
        wolf.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        wolf.m_21828_(player);
        level.m_7967_((Entity)wolf);
    }

    private static void applyCatCompanionBlessing(Player player, ServerLevel level) {
        player.m_213846_((Component)Component.m_237115_((String)"message.blessing.cat"));
        Cat cat = new Cat(EntityType.f_20553_, (Level)level);
        cat.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        cat.m_21828_(player);
        level.m_7967_((Entity)cat);
    }

    private static void applyExperienceBlessing(Player player, ServerLevel level) {
        int orbValue;
        player.m_213846_((Component)Component.m_237115_((String)"message.blessing.experience"));
        for (int experienceAmount = 100; experienceAmount > 0; experienceAmount -= orbValue) {
            orbValue = ExperienceOrb.m_20782_((int)experienceAmount);
            level.m_7967_((Entity)new ExperienceOrb((Level)level, player.m_20185_(), player.m_20186_(), player.m_20189_(), orbValue));
        }
    }

    private void giveItemReward(Player player, ServerLevel level, BlockPos pos) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.name));
        if (item != null) {
            ItemStack rewardStack = new ItemStack((ItemLike)item);
            if (!player.m_150109_().m_36054_(rewardStack)) {
                player.m_36176_(rewardStack, false);
            }
            Blessing.applyBlessing(player, level, pos, player.m_20185_(), player.m_20186_(), player.m_20189_());
        }
    }

    public static void applyBlessing(Player player, ServerLevel level, BlockPos pos, double itemX, double itemY, double itemZ) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, itemX, itemY, itemZ, 20, 0.5, 0.5, 0.5, 0.0);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, 1.0f);
        Blessing.generateParticleCircle(level, pos);
    }

    private static void generateParticleCircle(ServerLevel level, BlockPos pos) {
        double radius = 3.0;
        int particles = 40;
        double height = 1.5;
        for (int i = 0; i < particles; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particles;
            double x = (double)pos.m_123341_() + 0.5 + radius * Math.cos(angle);
            double y = (double)pos.m_123342_() + height;
            double z = (double)pos.m_123343_() + 0.5 + radius * Math.sin(angle);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void giveRandomReward(Player player, ResourceKey<Level> dimension) {
        List<Blessing> blessings;
        Random random = new Random();
        if (dimension.equals((Object)Level.f_46428_)) {
            blessings = Config.overworldBlessings;
        } else if (dimension.equals((Object)Level.f_46429_)) {
            blessings = Config.netherBlessings;
        } else if (dimension.equals((Object)Level.f_46430_)) {
            blessings = Config.endBlessings;
        } else {
            return;
        }
        if (blessings.isEmpty()) {
            return;
        }
        Blessing selectedBlessing = Blessing.selectBlessing(blessings, random);
        if (selectedBlessing != null) {
            selectedBlessing.apply(player, (ServerLevel)player.m_9236_(), player.m_20183_());
        }
    }

    private static Blessing selectBlessing(List<Blessing> blessings, Random random) {
        double totalProbability = blessings.stream().mapToDouble(Blessing::probability).sum();
        double rand = random.nextDouble() * totalProbability;
        double cumulativeProbability = 0.0;
        for (Blessing blessing : blessings) {
            if (!(rand <= (cumulativeProbability += blessing.probability()))) continue;
            return blessing;
        }
        return null;
    }
}

