/*
 * Decompiled with CFR 0.152.
 */
package com.sn4pe.wishing_wells;

import com.sn4pe.wishing_wells.blessing.Blessing;
import com.sn4pe.wishing_wells.data.TossableItem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="wishing_wells", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> TOSSABLE_ITEMS = BUILDER.comment("A list of items that can be tossed and their probabilities of success.").defineListAllowEmpty("tossableItems", List.of("minecraft:gold_ingot,0.5", "minecraft:diamond,0.7"), obj -> obj instanceof String && ((String)obj).contains(","));
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> OVERWORLD_BLESSINGS = BUILDER.comment("A list of items and blessings with their probabilities for rewards in the Overworld.").defineListAllowEmpty("overworldBlessings", List.of("minecraft:diamond,0.2", "minecraft:emerald,0.2", "minecraft:golden_apple,0.2", "minecraft:experience_bottle,0.2", "minecraft:iron_ingot,0.2", "blessing:heal,0.1", "blessing:speed,0.1", "blessing:strength,0.1", "blessing:wolf,0.1", "blessing:cat,0.1"), obj -> obj instanceof String && ((String)obj).contains(","));
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> NETHER_BLESSINGS = BUILDER.comment("A list of items and blessings with their probabilities for rewards in the Nether.").defineListAllowEmpty("netherBlessings", List.of("minecraft:netherite_ingot,0.1", "minecraft:blaze_rod,0.3", "minecraft:ghast_tear,0.2", "minecraft:quartz,0.3", "minecraft:glowstone_dust,0.1", "blessing:heal,0.1", "blessing:speed,0.1", "blessing:strength,0.1", "blessing:wolf,0.1", "blessing:cat,0.1"), obj -> obj instanceof String && ((String)obj).contains(","));
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> END_BLESSINGS = BUILDER.comment("A list of items and blessings with their probabilities for rewards in the End.").defineListAllowEmpty("endBlessings", List.of("minecraft:elytra,0.1", "minecraft:dragon_breath,0.2", "minecraft:ender_pearl,0.3", "minecraft:shulker_shell,0.3", "minecraft:end_stone,0.1", "blessing:heal,0.1", "blessing:speed,0.1", "blessing:strength,0.1", "blessing:wolf,0.1", "blessing:cat,0.1"), obj -> obj instanceof String && ((String)obj).contains(","));
    private static final ForgeConfigSpec.IntValue CURSE_FIXED_THRESHOLD = BUILDER.comment("The fixed number of throws before a curse is applied. Set to -1 to use the range instead.").defineInRange("curseFixedThreshold", -1, -1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue CURSE_MIN_THRESHOLD = BUILDER.comment("The minimum number of throws before a curse is applied if using a range.").defineInRange("curseMinThreshold", 3, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue CURSE_MAX_THRESHOLD = BUILDER.comment("The maximum number of throws before a curse is applied if using a range.").defineInRange("curseMaxThreshold", 10, 0, Integer.MAX_VALUE);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static List<TossableItem> tossableItems;
    public static List<Blessing> overworldBlessings;
    public static List<Blessing> netherBlessings;
    public static List<Blessing> endBlessings;
    public static int curseFixedThreshold;
    public static int curseMinThreshold;
    public static int curseMaxThreshold;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        tossableItems = ((List)TOSSABLE_ITEMS.get()).stream().map(Config::parseTossableItem).collect(Collectors.toList());
        overworldBlessings = ((List)OVERWORLD_BLESSINGS.get()).stream().map(Config::parseBlessing).collect(Collectors.toList());
        netherBlessings = ((List)NETHER_BLESSINGS.get()).stream().map(Config::parseBlessing).collect(Collectors.toList());
        endBlessings = ((List)END_BLESSINGS.get()).stream().map(Config::parseBlessing).collect(Collectors.toList());
        curseFixedThreshold = (Integer)CURSE_FIXED_THRESHOLD.get();
        curseMinThreshold = (Integer)CURSE_MIN_THRESHOLD.get();
        curseMaxThreshold = (Integer)CURSE_MAX_THRESHOLD.get();
    }

    private static TossableItem parseTossableItem(String itemString) {
        String[] parts = itemString.split(",");
        String itemName = parts[0];
        double probability = Double.parseDouble(parts[1]);
        return new TossableItem(itemName, probability);
    }

    private static Blessing parseBlessing(String blessingString) {
        String[] parts = blessingString.split(",");
        String name = parts[0];
        double probability = Double.parseDouble(parts[1]);
        return new Blessing(name, probability);
    }
}

