/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.data_handler.handlers;

import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.handlers.ProbabilityDataHandler;
import com.legacy.structure_gel.api.data_handler.parsing.DataMap;
import com.legacy.structure_gel.api.data_handler.parsing.DataParser;
import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.core.block_entity.DynamicSpawnerBlockEntity;
import com.legacy.structure_gel.core.registry.SGRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;

public class DynamicSpawnerHandler
extends ProbabilityDataHandler<DynamicSpawnerHandler> {
    private static final DataParser PARSER = DataParser.of(DataHandlerType.DYNAMIC_SPAWNER, parser -> {
        parser.add("dynamic_spawner_type", DynamicSpawnerType.DEFAULT.getRegistryName()).setSuggestions(DynamicSpawnerType.REGISTRY::getKeys, ResourceLocation::toString);
        parser.add("generation_chance", 1.0f, 0.0f, 1.0f);
        parser.add("min_exp", DynamicSpawnerBlockEntity.ExpRange.VANILLA.min, 0, Integer.MAX_VALUE);
        parser.add("max_exp", DynamicSpawnerBlockEntity.ExpRange.VANILLA.max, 0, Integer.MAX_VALUE);
    });
    private ResourceLocation dynamicSpawnerType;
    private DynamicSpawnerBlockEntity.ExpRange expRange;

    public DynamicSpawnerHandler(DataMap data) {
        super(data, "generation_chance");
        this.dynamicSpawnerType = data.get("dynamic_spawner_type", ResourceLocation.class);
        this.expRange = new DynamicSpawnerBlockEntity.ExpRange(data.getInt("min_exp"), data.getInt("max_exp"));
    }

    public static DataParser parser() {
        return PARSER;
    }

    @Override
    protected void handle(BlockState dataHandler, BlockPos pos, WorldGenLevel level, RandomSource rand, BoundingBox bounds, StructurePiece piece) {
        level.m_7731_(pos, SGRegistry.Blocks.DYNAMIC_SPAWNER.get().m_49966_(), 2);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DynamicSpawnerBlockEntity) {
            DynamicSpawnerBlockEntity dynamicSpawner = (DynamicSpawnerBlockEntity)blockEntity;
            dynamicSpawner.setSpawner(DynamicSpawnerType.REGISTRY.get(this.dynamicSpawnerType));
            dynamicSpawner.setExpRange(this.expRange);
            dynamicSpawner.m_6596_();
        }
        if (level instanceof ServerLevel) {
            BlockState updatedState = level.m_8055_(pos);
            ((ServerLevel)level).m_7260_(pos, updatedState, updatedState, 3);
        }
    }
}

