/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.lootbundles.item;

import cy.jdkdigital.lootbundles.LootBundleConfig;
import cy.jdkdigital.lootbundles.init.ModTags;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class LootBundle
extends Item {
    private static final List<Item> possibleItems = new ArrayList<Item>();

    public LootBundle(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.m_5776_()) {
            ItemStack itemStack = player.m_21120_(hand);
            int usedBundles = 1;
            if (player.m_6144_()) {
                usedBundles = itemStack.m_41613_();
            }
            boolean hasUsedBundle = false;
            for (int k = 0; k < usedBundles; ++k) {
                int max;
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                int min = (Integer)LootBundleConfig.COMMON.minLootAmount.get();
                int count = min <= (max = ((Integer)LootBundleConfig.COMMON.maxLootAmount.get()).intValue()) ? level.f_46441_.m_216339_(min, max + 1) : level.f_46441_.m_188503_(max + 1);
                int i = 0;
                for (int u = 0; i < count && u < 200; ++u) {
                    ItemStack randomStack = LootBundle.getRandomItem(level.f_46441_);
                    if (randomStack.m_41619_()) continue;
                    items.add(randomStack);
                    ++i;
                }
                if (!LootBundle.dropContents(items, player)) continue;
                itemStack.m_41774_(1);
                this.playDropContentsSound((Entity)player);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                hasUsedBundle = true;
            }
            if (hasUsedBundle) {
                return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
            }
        }
        return super.m_7203_(level, player, hand);
    }

    private static ItemStack getRandomItem(RandomSource rand) {
        if (possibleItems.isEmpty()) {
            if (((Boolean)LootBundleConfig.COMMON.whitelist.get()).booleanValue()) {
                BuiltInRegistries.f_257033_.m_206058_(ModTags.WHITELIST).forEach(itemHolder -> {
                    Item item = (Item)itemHolder.m_203334_();
                    if (ForgeRegistries.ITEMS.getKey((Object)item) != null && LootBundle.isItemAllowed(item)) {
                        possibleItems.add(item);
                    }
                });
            } else {
                ForgeRegistries.ITEMS.getValues().forEach(item -> {
                    if (LootBundle.isItemAllowed(item)) {
                        possibleItems.add((Item)item);
                    }
                });
            }
        }
        if (possibleItems.size() > 0) {
            Item item2 = possibleItems.get(rand.m_188503_(possibleItems.size()));
            return new ItemStack((ItemLike)item2, Math.min(item2.m_41459_(), rand.m_216339_(1, (Integer)LootBundleConfig.COMMON.maxStackSize.get() + 1)));
        }
        return ItemStack.f_41583_;
    }

    private static boolean dropContents(List<ItemStack> stacks, Player player) {
        if (player instanceof ServerPlayer) {
            for (ItemStack stack : stacks) {
                if (((Boolean)LootBundleConfig.COMMON.inventoryInsert.get()).booleanValue() && player.m_150109_().m_36062_() > 0) {
                    player.m_36356_(stack);
                    continue;
                }
                player.m_36176_(stack, true);
            }
        }
        return true;
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private static boolean isItemAllowed(Item item) {
        if (!item.m_204114_().m_203656_(ModTags.BLACKLIST)) {
            if (!item.m_204114_().m_203656_(ModTags.WHITELIST) && !((List)LootBundleConfig.COMMON.disallowedItemNames.get()).isEmpty()) {
                for (String s : (List)LootBundleConfig.COMMON.disallowedItemNames.get()) {
                    if (!ForgeRegistries.ITEMS.getKey((Object)item).toString().contains(s)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

