/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.DataStructures.DataHolder;
import com.darkere.crashutils.Screens.CUButton;
import com.darkere.crashutils.Screens.CUScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;

public class CUOption {
    ResourceLocation rl;
    int number;
    ChunkPos chunkPos;
    BlockPos blockPos;
    String string;
    String extra;
    UUID id;
    List<Button> buttons = new ArrayList<Button>();

    public CUOption(String string, String extra) {
        this.string = string;
        this.extra = extra;
    }

    public CUOption(String string) {
        this.string = string;
    }

    public CUOption(String string, int number) {
        this.number = number;
        this.string = string;
    }

    public CUOption(ResourceLocation rl, int number) {
        this.rl = rl;
        this.number = number;
    }

    public CUOption(ChunkPos chunkPos, int number, ResourceLocation rl) {
        this.chunkPos = chunkPos;
        this.number = number;
        this.rl = rl;
    }

    public CUOption(ResourceLocation rl) {
        this.rl = rl;
    }

    public CUOption(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public CUOption(ChunkPos chunkPos) {
        this.chunkPos = chunkPos;
    }

    public CUOption(BlockPos pos, UUID id) {
        this.blockPos = pos;
        this.id = id;
    }

    public ResourceLocation getRl() {
        return this.rl;
    }

    public int getNumber() {
        return this.number;
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public CUOption addButton(String text, String tooltip, Button.OnPress action) {
        int n = Minecraft.m_91087_().f_91062_.m_92895_(text) + 4;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.buttons.add(new CUButton(0, 0, n, 9 + 3, (Component)CommandUtils.CreateTextComponent(text), action, tooltip));
        return this;
    }

    public int getButtonWidth(int x) {
        int width = 0;
        for (int i = this.buttons.size() - 1; i >= x; --i) {
            width += this.buttons.get(i).m_5711_();
        }
        return width;
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.number != 0) {
            builder.append(this.number).append("x");
        }
        if (this.rl != null) {
            builder.append(" ").append(this.rl);
        }
        if (this.chunkPos != null) {
            builder.append(" ").append(this.chunkPos);
        }
        if (this.blockPos != null) {
            builder.append(" ").append(this.blockPos);
        }
        if (this.string != null) {
            builder.append(" ").append(this.string);
        }
        if (this.extra != null) {
            builder.append(" ").append(this.extra);
        }
        return builder.toString();
    }

    public boolean shouldBeFilteredOut(String filter) {
        return this.rl != null && !this.rl.toString().startsWith(filter) && !this.rl.m_135815_().startsWith(filter);
    }

    public boolean checkClick(int mx, int my, CUScreen screen) {
        for (Button x : this.buttons) {
            if (!x.m_5953_((double)mx, (double)my)) continue;
            x.m_5691_();
            CrashUtils.runInTwoTicks(world -> DataHolder.requestImmediateUpdate(screen.dim));
            return true;
        }
        return false;
    }

    public String getString() {
        return this.string;
    }
}

