/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core.crafting.processoverride;

import java.util.List;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraftforge.common.util.FakePlayer;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.core.crafting.processoverride.CraftingGrid;
import org.cyclops.integratedcrafting.core.crafting.processoverride.CraftingProcessOverrideCraftingTable;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingProcessOverrideStonecutter
implements ICraftingProcessOverride {
    @Override
    public boolean isApplicable(PartPos target) {
        return target.getPos().getLevel(true).m_8055_(target.getPos().getBlockPos()).m_60734_() instanceof StonecutterBlock;
    }

    @Override
    public boolean craft(Function<IngredientComponent<?, ?>, PartPos> targetGetter, IMixedIngredients ingredients, IRecipeDefinition recipe, ICraftingResultsSink resultsSink, CraftingJob craftingJob, boolean simulate) {
        PartPos target = targetGetter.apply(IngredientComponent.ITEMSTACK);
        CraftingGrid grid = new CraftingGrid(ingredients, 1, 1);
        Level level = target.getPos().getLevel(true);
        IMixedIngredients output = recipe.getOutput();
        List recipeOutputs = output.getInstances(IngredientComponent.ITEMSTACK);
        if (output.getComponents().size() != 1 || recipeOutputs.size() != 1) {
            throw new IllegalArgumentException("Can only craft for an output of 1 item, while got" + String.valueOf(recipeOutputs == null ? "null" : Integer.valueOf(recipeOutputs.size())));
        }
        ItemStack recipeOutput = (ItemStack)recipeOutputs.get(0);
        return CraftingHelpers.findRecipes((Level)level, (RecipeType)RecipeType.f_44112_).stream().filter(recipeHolder -> recipeHolder.m_5818_((Container)grid, level) && ItemStack.m_150942_((ItemStack)recipeHolder.m_8043_(level.m_9598_()), (ItemStack)recipeOutput)).findFirst().map(stonecutterRecipe -> {
            ItemStack result = stonecutterRecipe.m_5874_((Container)grid, level.m_9598_());
            if (result.m_41619_()) {
                return false;
            }
            if (!simulate) {
                FakePlayer player = CraftingProcessOverrideCraftingTable.getFakePlayer((ServerLevel)target.getPos().getLevel(true));
                result.m_41678_(target.getPos().getLevel(true), (Player)player, 1);
                resultsSink.addResult(IngredientComponent.ITEMSTACK, result);
                for (ItemStack remainingItem : stonecutterRecipe.m_7457_((Container)grid)) {
                    if (remainingItem.m_41619_()) continue;
                    resultsSink.addResult(IngredientComponent.ITEMSTACK, remainingItem);
                }
            }
            return true;
        }).orElse(false);
    }
}

