/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core.crafting.processoverride;

import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SmithingTableBlock;
import net.minecraftforge.common.util.FakePlayer;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.core.crafting.processoverride.CraftingGrid;
import org.cyclops.integratedcrafting.core.crafting.processoverride.CraftingProcessOverrideCraftingTable;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingProcessOverrideSmithingTable
implements ICraftingProcessOverride {
    @Override
    public boolean isApplicable(PartPos target) {
        return target.getPos().getLevel(true).m_8055_(target.getPos().getBlockPos()).m_60734_() instanceof SmithingTableBlock;
    }

    @Override
    public boolean craft(Function<IngredientComponent<?, ?>, PartPos> targetGetter, IMixedIngredients ingredients, IRecipeDefinition recipe, ICraftingResultsSink resultsSink, CraftingJob craftingJob, boolean simulate) {
        PartPos target = targetGetter.apply(IngredientComponent.ITEMSTACK);
        CraftingGrid grid = new CraftingGrid(ingredients, 1, 3);
        Level level = target.getPos().getLevel(true);
        return CraftingHelpers.findServerRecipe((RecipeType)RecipeType.f_44113_, (Container)grid, (Level)level).map(smithingRecipe -> {
            ItemStack result = smithingRecipe.m_5874_((Container)grid, level.m_9598_());
            if (result.m_41619_()) {
                return false;
            }
            if (!simulate) {
                FakePlayer player = CraftingProcessOverrideCraftingTable.getFakePlayer((ServerLevel)target.getPos().getLevel(true));
                result.m_41678_(target.getPos().getLevel(true), (Player)player, 1);
                resultsSink.addResult(IngredientComponent.ITEMSTACK, result);
                for (ItemStack remainingItem : smithingRecipe.m_7457_((Container)grid)) {
                    if (remainingItem.m_41619_()) continue;
                    resultsSink.addResult(IngredientComponent.ITEMSTACK, remainingItem);
                }
            }
            return true;
        }).orElse(false);
    }
}

