/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientInstanceWrapper;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.core.CraftingJobHandler;
import org.cyclops.integrateddynamics.core.network.IIngredientChannelInsertPreConsumer;
import org.jetbrains.annotations.NotNull;

public class PendingCraftingJobResultIndexObserver<T, M>
implements IIngredientChannelInsertPreConsumer<T> {
    private final IngredientComponent<T, M> ingredientComponent;
    private final CraftingJobHandler handler;
    private final ICraftingNetwork craftingNetwork;

    public PendingCraftingJobResultIndexObserver(IngredientComponent<T, M> ingredientComponent, CraftingJobHandler handler, ICraftingNetwork craftingNetwork) {
        this.ingredientComponent = ingredientComponent;
        this.handler = handler;
        this.craftingNetwork = craftingNetwork;
    }

    public IngredientInstanceWrapper<T, M> addIngredient(IngredientInstanceWrapper<T, M> instanceWrapper, int channel, boolean simulate) {
        IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
        long instanceAmount = matcher.getQuantity(instanceWrapper.getInstance());
        Int2ObjectMap<List<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>>> processingJobs = this.handler.getProcessingCraftingJobsPendingIngredients();
        ObjectIterator jobsEntryIt = processingJobs.int2ObjectEntrySet().iterator();
        while (jobsEntryIt.hasNext() && instanceAmount > 0L) {
            Int2ObjectMap.Entry jobsEntry = (Int2ObjectMap.Entry)jobsEntryIt.next();
            int craftingJobId = jobsEntry.getIntKey();
            CraftingJob craftingJob = (CraftingJob)this.handler.getAllCraftingJobs().get(jobsEntry.getIntKey());
            if (craftingJob == null || craftingJob.getChannel() != -1 && craftingJob.getChannel() != channel) continue;
            Iterator<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>> jobEntryIt = ((List)jobsEntry.getValue()).iterator();
            while (jobEntryIt.hasNext() && instanceAmount > 0L) {
                Map jobEntry = (Map)jobEntryIt.next();
                List pendingIngredientsUnsafe = (List)jobEntry.get(this.ingredientComponent);
                if (pendingIngredientsUnsafe == null) continue;
                List pendingIngredients = pendingIngredientsUnsafe;
                ListIterator<PrototypedIngredient> it = pendingIngredients.listIterator();
                while (it.hasNext() && instanceAmount > 0L) {
                    long initialQuantity;
                    IPrototypedIngredient prototypedIngredient = (IPrototypedIngredient)it.next();
                    long remainingQuantity = initialQuantity = matcher.getQuantity(prototypedIngredient.getPrototype());
                    if (matcher.matches(instanceWrapper.getInstance(), prototypedIngredient.getPrototype(), prototypedIngredient.getCondition())) {
                        long extractedQuantityToAssign = Math.min(remainingQuantity, instanceAmount);
                        remainingQuantity -= extractedQuantityToAssign;
                        Object extracted = matcher.withQuantity(instanceWrapper.getInstance(), extractedQuantityToAssign);
                        IntIterator dependentJobs = craftingJob.getDependentCraftingJobs().intIterator();
                        while (dependentJobs.hasNext()) {
                            long missingQuantity;
                            CraftingJob dependentJob = this.craftingNetwork.getCraftingJob(craftingJob.getChannel(), dependentJobs.nextInt());
                            if (dependentJob == null || (missingQuantity = dependentJob.getMissingIngredientQuantity(this.ingredientComponent, extracted)) <= 0L) continue;
                            long toExtractQuantity = Math.min(missingQuantity, extractedQuantityToAssign);
                            Object toExtract = matcher.withQuantity(extracted, toExtractQuantity);
                            if (!simulate) {
                                dependentJob.addToIngredientsStorageBuffer(this.ingredientComponent, toExtract);
                            }
                            instanceAmount -= toExtractQuantity;
                            if ((extractedQuantityToAssign -= toExtractQuantity) != 0L) continue;
                            break;
                        }
                    }
                    if (simulate) continue;
                    if (remainingQuantity <= 0L) {
                        it.remove();
                        continue;
                    }
                    if (initialQuantity == remainingQuantity) continue;
                    it.set(new PrototypedIngredient(this.ingredientComponent, matcher.withQuantity(prototypedIngredient.getPrototype(), remainingQuantity), prototypedIngredient.getCondition()));
                }
                if (simulate) continue;
                this.onPendingIngredientsEmpty(jobsEntryIt, jobsEntry, jobEntryIt, jobEntry, pendingIngredients, craftingJobId);
            }
        }
        return new IngredientInstanceWrapper(instanceWrapper.getComponent(), matcher.withQuantity(instanceWrapper.getInstance(), instanceAmount));
    }

    protected void onPendingIngredientsEmpty(ObjectIterator<Int2ObjectMap.Entry<List<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>>>> jobsEntryIt, Int2ObjectMap.Entry<List<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>>> jobsEntry, Iterator<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>> jobEntryIt, Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>> jobEntry, List<IPrototypedIngredient<T, M>> pendingIngredients, int craftingJobId) {
        if (pendingIngredients.isEmpty()) {
            this.handler.getObserversPendingDeletion().add(this.ingredientComponent);
            jobEntry.remove(this.ingredientComponent);
            if (jobEntry.isEmpty()) {
                this.handler.onCraftingJobEntryFinished(this.craftingNetwork, craftingJobId);
                jobEntryIt.remove();
            }
            if (((List)jobsEntry.getValue()).isEmpty()) {
                this.handler.onCraftingJobFinished((CraftingJob)this.handler.getAllCraftingJobs().get(craftingJobId));
                this.handler.getProcessingCraftingJobsRaw().remove(craftingJobId);
                jobsEntryIt.remove();
            }
        }
    }

    public T insert(int channel, @NotNull T ingredient, boolean simulate) {
        IngredientInstanceWrapper<T, M> instanceWrapper = this.addIngredient(new IngredientInstanceWrapper(this.ingredientComponent, ingredient), channel, simulate);
        return (T)instanceWrapper.getInstance();
    }
}

