/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FilterItem
extends FilterBase {
    protected boolean whitelistMode = true;
    protected String tagString = "";
    protected boolean tagMode = false;
    protected ItemStack filterStack = ItemStack.f_41583_;
    protected boolean fuzzyMatch = false;
    protected boolean matchCount = false;
    protected boolean filterBlocks = false;
    protected boolean filterItems = false;
    public boolean dataChanged = false;
    private TagKey<Item> tagCache = null;

    public FilterItem(EntityFilter filter) {
        super(filter);
    }

    private void clearCache() {
        this.tagCache = null;
    }

    public boolean isWhitelistMode() {
        return this.whitelistMode;
    }

    public String getTagString() {
        return this.tagString;
    }

    public boolean isTagMode() {
        return this.tagMode;
    }

    public ItemStack getFilterStack() {
        return this.filterStack;
    }

    public boolean isFuzzyMatch() {
        return this.fuzzyMatch;
    }

    public boolean isMatchCount() {
        return this.matchCount;
    }

    public boolean isFilterBlocks() {
        return this.filterBlocks;
    }

    public boolean isFilterItems() {
        return this.filterItems;
    }

    public void setWhitelistMode(boolean whitelistMode) {
        boolean prev = this.whitelistMode;
        this.whitelistMode = whitelistMode;
        this.getFilter().nodeModified(this);
        this.whitelistMode = prev;
    }

    public void setTagString(String tagString) {
        this.tagString = tagString;
        this.clearCache();
        this.getFilter().nodeModified(this);
    }

    public void setTagMode(boolean tagMode) {
        this.tagMode = tagMode;
        this.getFilter().nodeModified(this);
    }

    public void setFilterStack(ItemStack filterStack) {
        this.filterStack = filterStack;
        this.getFilter().nodeModified(this);
    }

    public void setFuzzyMatch(boolean fuzzyMatch) {
        this.fuzzyMatch = fuzzyMatch;
        this.getFilter().nodeModified(this);
    }

    public void setMatchCount(boolean matchCount) {
        this.matchCount = matchCount;
        this.getFilter().nodeModified(this);
    }

    public void cycleItemsBlocks() {
        if (this.isFilterItems()) {
            this.setFilterItemsBlocks(false, true);
        } else if (this.isFilterBlocks()) {
            this.setFilterItemsBlocks(false, false);
        } else {
            this.setFilterItemsBlocks(true, false);
        }
    }

    public void setFilterItemsBlocks(boolean filterItems, boolean filterBlocks) {
        boolean prev = this.filterItems;
        boolean prevBlocks = this.filterBlocks;
        this.filterItems = filterItems;
        this.filterBlocks = filterBlocks;
        this.getFilter().nodeModified(this);
        this.filterItems = prev;
        this.filterBlocks = prevBlocks;
    }

    @Override
    public boolean test(Entity entity) {
        if (!(entity instanceof ItemEntity)) {
            return !this.whitelistMode;
        }
        ItemEntity item = (ItemEntity)entity;
        return this.testItem(item.m_32055_());
    }

    public boolean testItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return !this.whitelistMode;
        }
        boolean match = true;
        if (this.isTagMode()) {
            match = stack.m_204117_(this.getTag());
        } else if (!this.filterStack.m_41619_()) {
            boolean bl = this.fuzzyMatch ? ItemStack.m_41656_((ItemStack)this.filterStack, (ItemStack)stack) : (match = ItemStack.m_150942_((ItemStack)this.filterStack, (ItemStack)stack) && (this.filterStack.m_41613_() == stack.m_41613_() || !this.matchCount));
        }
        if (this.filterStack.m_41619_() && !this.isTagMode()) {
            if (this.filterBlocks) {
                match = stack.m_41720_() instanceof BlockItem;
            } else if (this.filterItems) {
                match = !(stack.m_41720_() instanceof BlockItem);
            }
        }
        return match == this.whitelistMode;
    }

    public TagKey<Item> getTag() {
        if (this.tagCache == null) {
            this.tagCache = ItemTags.create((ResourceLocation)new ResourceLocation(this.tagString));
        }
        return this.tagCache;
    }

    @Override
    public FilterType getType() {
        return FilterType.ITEM_FILTER;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128379_("whitelist_mode", this.whitelistMode);
        compound.m_128359_("tag_string", this.tagString);
        compound.m_128379_("tag_mode", this.tagMode);
        compound.m_128365_("filter_stack", (Tag)this.filterStack.serializeNBT());
        compound.m_128379_("fuzzy_match", this.fuzzyMatch);
        compound.m_128379_("match_count", this.matchCount);
        compound.m_128379_("filter_blocks", this.filterBlocks);
        compound.m_128379_("filter_items", this.filterItems);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.whitelistMode = compound.m_128471_("whitelist_mode");
        this.tagString = compound.m_128461_("tag_string");
        this.tagMode = compound.m_128471_("tag_mode");
        this.filterStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("filter_stack"));
        this.fuzzyMatch = compound.m_128471_("fuzzy_match");
        this.matchCount = compound.m_128471_("match_count");
        this.filterBlocks = compound.m_128471_("filter_blocks");
        this.filterItems = compound.m_128471_("filter_items");
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.whitelistMode);
        output.writeString(this.tagString);
        output.writeBoolean(this.tagMode);
        output.writeItemStack(this.filterStack);
        output.writeBoolean(this.fuzzyMatch);
        output.writeBoolean(this.matchCount);
        output.writeBoolean(this.filterBlocks);
        output.writeBoolean(this.filterItems);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.whitelistMode = input.readBoolean();
        this.tagString = input.readString();
        this.tagMode = input.readBoolean();
        this.filterStack = input.readItemStack();
        this.fuzzyMatch = input.readBoolean();
        this.matchCount = input.readBoolean();
        this.filterBlocks = input.readBoolean();
        this.filterItems = input.readBoolean();
        this.dataChanged = true;
    }
}

