/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ManagedStack
extends AbstractManagedData<ItemStack> {
    private ItemStack value;
    private ItemStack lastValue;
    protected Function<ItemStack, ItemStack> validator = null;

    public ManagedStack(String name, ItemStack defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.lastValue = defaultValue.m_41777_();
    }

    public ManagedStack(String name, DataFlags ... flags) {
        this(name, ItemStack.f_41583_, flags);
    }

    public ItemStack set(ItemStack value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            ItemStack prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.lastValue = prev.m_41777_();
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public ItemStack get() {
        return this.value;
    }

    public ManagedStack setValidator(Function<ItemStack, ItemStack> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public boolean isDirty(boolean reset) {
        if (this.lastValue != null && !this.lastValue.equals(this.value)) {
            if (reset) {
                this.lastValue = this.value.m_41777_();
            }
            return true;
        }
        return super.isDirty(reset);
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeItemStack(this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readItemStack();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundTag compound) {
        compound.m_128365_(this.name, (Tag)this.value.m_41739_(new CompoundTag()));
    }

    @Override
    public void fromNBT(CompoundTag compound) {
        this.value = ItemStack.m_41712_((CompoundTag)compound.m_128469_(this.name));
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }
}

