/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ManagedNBT
extends AbstractManagedData<CompoundTag> {
    private CompoundTag value;
    private CompoundTag lastValue;
    protected Function<CompoundTag, CompoundTag> validator = null;

    public ManagedNBT(String name, CompoundTag defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.lastValue = defaultValue.m_6426_();
    }

    public ManagedNBT(String name, DataFlags ... flags) {
        this(name, new CompoundTag(), flags);
    }

    public CompoundTag set(CompoundTag value) {
        this.lastValue = value.m_6426_();
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            CompoundTag prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public CompoundTag get() {
        return this.value;
    }

    public ManagedNBT setValidator(Function<CompoundTag, CompoundTag> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public boolean isDirty(boolean reset) {
        if (this.lastValue != null && !this.lastValue.equals((Object)this.value)) {
            if (reset) {
                this.lastValue = this.value.m_6426_();
            }
            return true;
        }
        return super.isDirty(reset);
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeCompoundNBT(this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readCompoundNBT();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundTag compound) {
        compound.m_128365_(this.name, (Tag)this.value);
    }

    @Override
    public void fromNBT(CompoundTag compound) {
        this.value = compound.m_128469_(this.name);
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }
}

