/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;

public class ManagedLong
extends AbstractManagedData<Long> {
    private long value;
    protected Function<Long, Long> validator = null;

    public ManagedLong(String name, long defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
    }

    public ManagedLong(String name, DataFlags ... flags) {
        this(name, 0L, flags);
    }

    public long set(long value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            long prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public long get() {
        return this.value;
    }

    public ManagedLong setValidator(Function<Long, Long> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeLong(this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readLong();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundTag compound) {
        compound.m_128356_(this.name, this.value);
    }

    @Override
    public void fromNBT(CompoundTag compound) {
        this.value = compound.m_128454_(this.name);
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }

    public long add(long add) {
        return this.set(this.get() + add);
    }

    public long subtract(long subtract) {
        return this.set(this.get() - subtract);
    }

    public long multiply(long multiplyBy) {
        return this.set(this.get() * multiplyBy);
    }

    public long divide(long divideBy) {
        return this.set(this.get() / divideBy);
    }

    public long zero() {
        return this.set(0L);
    }

    public long inc() {
        return this.add(1L);
    }

    public long dec() {
        return this.subtract(1L);
    }
}

