/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.handlers.BCEventHandler;
import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.inventory.ContainerPlayerAccess;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.Pair;
import com.brandon3055.brandonscore.lib.StringyStacks;
import com.brandon3055.brandonscore.multiblock.MultiBlockManager;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.brandon3055.brandonscore.utils.Utils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.io.IOUtils;

public class BCUtilCommands {
    private static Random rand = new Random();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"bcore_util").then(BCUtilCommands.registerNBT())).then(BCUtilCommands.registerStackString())).then(BCUtilCommands.registerNoClip())).then(BCUtilCommands.registerUUID())).then(BCUtilCommands.registerDumpEvents())).then(BCUtilCommands.registerEggify())).then(BCUtilCommands.registerPlaceMultiBlock())).then(BCUtilCommands.reloadContributors())).then(BCUtilCommands.registerTileDebug());
        if (BrandonsCore.inDev) {
            builder.then(BCUtilCommands.registerDev1());
            builder.then(BCUtilCommands.registerDev2());
        }
        dispatcher.register(builder);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerTileDebug() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"debug_tile").requires(cs -> cs.m_6761_(3))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            TileBCore tile;
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)context, (String)"pos");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            BlockEntity patt5626$temp = player.m_9236_().m_7702_(pos);
            if (!(patt5626$temp instanceof TileBCore) || !(tile = (TileBCore)patt5626$temp).toggleDebugOutput((Player)player)) {
                player.m_213846_((Component)Component.m_237113_((String)"This tile does not support Brandon's Core Debugging"));
            }
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"multiblock", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((context, builder) -> SharedSuggestionProvider.m_82926_(MultiBlockManager.getRegisteredIds(), (SuggestionsBuilder)builder)).executes(context -> MultiBlockManager.placeCommand(((CommandSourceStack)context.getSource()).m_81372_(), BlockPosArgument.m_118242_((CommandContext)context, (String)"pos"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"multiblock"), Vec3.f_82478_))).then(Commands.m_82129_((String)"rotation", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(context -> MultiBlockManager.placeCommand(((CommandSourceStack)context.getSource()).m_81372_(), BlockPosArgument.m_118242_((CommandContext)context, (String)"pos"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"multiblock"), Vec3Argument.m_120844_((CommandContext)context, (String)"rotation"))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> reloadContributors() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"reset_contrib_handler").requires(cs -> cs.m_6761_(3))).executes(context -> {
            ContributorHandler.reload();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Reset complete"), false);
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerPlaceMultiBlock() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"place_multiblock").requires(cs -> cs.m_6761_(3))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"multiblock", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((context, builder) -> SharedSuggestionProvider.m_82926_(MultiBlockManager.getRegisteredIds(), (SuggestionsBuilder)builder)).executes(context -> MultiBlockManager.placeCommand(((CommandSourceStack)context.getSource()).m_81372_(), BlockPosArgument.m_118242_((CommandContext)context, (String)"pos"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"multiblock"), Vec3.f_82478_))).then(Commands.m_82129_((String)"rotation", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(context -> MultiBlockManager.placeCommand(((CommandSourceStack)context.getSource()).m_81372_(), BlockPosArgument.m_118242_((CommandContext)context, (String)"pos"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"multiblock"), Vec3Argument.m_120844_((CommandContext)context, (String)"rotation"))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerNBT() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"nbt").requires(cs -> cs.m_6761_(0))).executes(context -> BCUtilCommands.functionNBT((CommandSourceStack)context.getSource()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerStackString() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"stack_string").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"from_string").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"give-to", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"stack-string", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BCUtilCommands.functionFromStackString((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"give-to"), StringArgumentType.getString((CommandContext)ctx, (String)"stack-string"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"to_string").requires(cs -> cs.m_6761_(0))).then(Commands.m_82127_((String)"id_only").executes(context -> BCUtilCommands.functionToStackString((CommandSourceStack)context.getSource(), false, false, false)))).then(Commands.m_82127_((String)"id_nbt").executes(context -> BCUtilCommands.functionToStackString((CommandSourceStack)context.getSource(), false, true, false)))).then(Commands.m_82127_((String)"id_count").executes(context -> BCUtilCommands.functionToStackString((CommandSourceStack)context.getSource(), true, false, false)))).then(Commands.m_82127_((String)"id_nbt_count").executes(context -> BCUtilCommands.functionToStackString((CommandSourceStack)context.getSource(), true, true, false)))).then(Commands.m_82127_((String)"id_nbt_capabilities").executes(context -> BCUtilCommands.functionToStackString((CommandSourceStack)context.getSource(), false, true, true)))).executes(context -> BCUtilCommands.functionToStackString((CommandSourceStack)context.getSource(), true, true, true)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerRegenChunk() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"regenchunk").requires(cs -> cs.m_6761_(3))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(ctx -> BCUtilCommands.regenChunk((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerNoClip() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"noclip").requires(cs -> cs.m_6761_(3))).executes(context -> BCUtilCommands.toggleNoClip((CommandSourceStack)context.getSource()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerUUID() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"uuid").requires(cs -> cs.m_6761_(0))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> BCUtilCommands.getUUID((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"target"))))).executes(ctx -> BCUtilCommands.getUUID((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerPlayerAccess() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"player_access").requires(cs -> cs.m_6761_(3))).then(Commands.m_82129_((String)"target", reader -> StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82981_(BCUtilCommands.accessiblePlayers((CommandSourceStack)context.getSource()).values().stream().map(GameProfile::getName), (SuggestionsBuilder)builder)).executes(context -> BCUtilCommands.playerAccess((CommandSourceStack)context.getSource(), (String)context.getArgument("target", String.class))))).then(Commands.m_82127_((String)"list").executes(context -> BCUtilCommands.playerAccess((CommandSourceStack)context.getSource(), null)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerDumpEvents() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"dump_event_listeners").requires(cs -> cs.m_6761_(0))).executes(ctx -> BCUtilCommands.dumpEventListeners((CommandSourceStack)ctx.getSource()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerEggify() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"eggify").requires(cs -> cs.m_6761_(3))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).executes(ctx -> BCUtilCommands.eggify((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91452_((CommandContext)ctx, (String)"target"))));
    }

    private static int functionNBT(CommandSourceStack source) throws CommandRuntimeException, CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        ItemStack stack = HandHelper.getMainFirst((Player)player);
        if (stack.m_41619_()) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"You are not holding an item!"));
        }
        if (!stack.m_41782_()) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"That stack has no NBT tag!"));
        }
        CompoundTag compound = stack.m_41783_();
        LogHelperBC.logNBT(compound);
        LogHelperBC.info(compound);
        StringBuilder builder = new StringBuilder();
        LogHelperBC.buildNBT(builder, (Tag)compound, "", "Tag", false);
        String[] lines = builder.toString().split("\n");
        DataUtils.forEach(lines, arg_0 -> BCUtilCommands.lambda$functionNBT$39((Player)player, arg_0));
        return 0;
    }

    private static int functionToStackString(CommandSourceStack source, boolean count, boolean nbt, boolean caps) throws CommandRuntimeException, CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        ItemStack stack = HandHelper.getMainFirst((Player)player);
        if (stack.m_41619_()) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"You are not holding an item!"));
        }
        String returnString = StringyStacks.toString(stack, nbt, count, caps);
        ChatHelper.sendMessage((Player)player, (Component)Component.m_237113_((String)"# The following is stack string for the held stack (click to copy) #").m_130940_(ChatFormatting.BLUE));
        MutableComponent textComponent = returnString.length() > 64 ? Component.m_237113_((String)(returnString.substring(0, 64) + "... ")).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)"(Mouseover for full)").m_130940_(ChatFormatting.DARK_AQUA).m_130940_(ChatFormatting.UNDERLINE)) : Component.m_237113_((String)returnString).m_130940_(ChatFormatting.GOLD);
        textComponent.m_6270_(textComponent.m_7383_().m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to copy to clipboard").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)("\n" + returnString)).m_130940_(ChatFormatting.GRAY)))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, returnString)));
        ChatHelper.sendMessage((Player)player, (Component)textComponent);
        StringyStacks.LOGGER.info(returnString);
        return 0;
    }

    private static int functionFromStackString(CommandSourceStack source, ServerPlayer player, String stackString) throws CommandRuntimeException, CommandSyntaxException {
        ItemStack stack = StringyStacks.fromString(stackString, null);
        if (stack == null) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"Invalid item string. You may find more details in the server console."));
        }
        boolean flag = player.m_150109_().m_36054_(stack);
        if (flag && stack.m_41619_()) {
            stack.m_41764_(1);
            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
            player.f_36095_.m_38946_();
        } else {
            ItemEntity itementity = player.m_36176_(stack, false);
            if (itementity != null) {
                itementity.m_32061_();
                itementity.m_32052_(player.m_20148_());
            }
        }
        return 0;
    }

    private static int regenChunk(CommandSourceStack source, int rad) throws CommandRuntimeException, CommandSyntaxException {
        for (int xOffset = -rad; xOffset <= rad; ++xOffset) {
            for (int yOffset = -rad; yOffset <= rad; ++yOffset) {
                ServerLevel world = source.m_81372_();
                ServerPlayer player = source.m_81375_();
                ServerChunkCache chunkProviderServer = world.m_7726_();
                ChunkGenerator chunkGenerator = chunkProviderServer.m_8481_();
            }
        }
        return 0;
    }

    private static int toggleNoClip(CommandSourceStack source) throws CommandRuntimeException, CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        boolean enabled = BCEventHandler.noClipPlayers.contains(player.m_20148_());
        if (enabled) {
            BCEventHandler.noClipPlayers.remove(player.m_20148_());
            BCoreNetwork.sendNoClip(player, false);
            source.m_288197_(() -> Component.m_237113_((String)"NoClip Disabled!"), true);
        } else {
            BCEventHandler.noClipPlayers.add(player.m_20148_());
            BCoreNetwork.sendNoClip(player, true);
            source.m_288197_(() -> Component.m_237113_((String)"NoClip Enabled!"), true);
        }
        return 0;
    }

    private static int getUUID(CommandSourceStack source, ServerPlayer player) throws CommandRuntimeException {
        MutableComponent comp = Component.m_237113_((String)(player.m_7755_().getString() + "'s UUID: " + ChatFormatting.UNDERLINE + player.m_20148_()));
        comp.m_6270_(comp.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, player.m_20148_().toString())));
        comp.m_6270_(comp.m_7383_().m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to copy to clipboard"))));
        source.m_288197_(() -> comp, true);
        return 0;
    }

    public static int dumpEventListeners(CommandSourceStack source) throws CommandRuntimeException {
        HashMap eventListenerMap = new HashMap();
        BCUtilCommands.dumpBus("EVENT_BUS", (EventBus)MinecraftForge.EVENT_BUS, eventListenerMap);
        StringBuilder builder = new StringBuilder("\n");
        for (String bus : eventListenerMap.keySet()) {
            builder.append("Dumping listeners for bus: ").append(bus).append("\n");
            Map busListeners = (Map)eventListenerMap.get(bus);
            ArrayList sortedClasses = Lists.newArrayList(busListeners.keySet());
            sortedClasses.sort(Comparator.comparing(Class::getName));
            for (Class eventClass : sortedClasses) {
                List listenerList = (List)busListeners.get(eventClass);
                listenerList.sort(Comparator.comparingInt(value -> ((EventPriority)value.key()).ordinal()));
                builder.append("    Handlers for event: ").append(eventClass).append("\n");
                for (Pair listener : listenerList) {
                    Method m = (Method)listener.value();
                    builder.append("        ").append(listener.key()).append(" ").append(m.getDeclaringClass().getName()).append(" ").append(m.getName()).append("(").append(BCUtilCommands.separateWithCommas(m.getParameterTypes())).append(")\n");
                }
                builder.append("\n");
            }
        }
        LogHelperBC.info(builder.toString());
        for (String s : builder.toString().split("\n")) {
            source.m_288197_(() -> Component.m_237113_((String)s), true);
        }
        return 0;
    }

    private static String separateWithCommas(Class<?>[] types) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < types.length; ++j) {
            sb.append(types[j].getTypeName());
            if (j >= types.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static void dumpBus(String name, EventBus bus, Map<String, Map<Class<?>, List<Pair<EventPriority, Method>>>> baseMap) throws CommandRuntimeException {
        Map map = baseMap.computeIfAbsent(name, eventBus -> new HashMap());
        try {
            ConcurrentHashMap listeners = (ConcurrentHashMap)ObfuscationReflectionHelper.getPrivateValue(EventBus.class, (Object)bus, (String)"listeners");
            for (Object obj : listeners.keySet()) {
                for (Method method : obj.getClass().getMethods()) {
                    SubscribeEvent anno = method.getAnnotation(SubscribeEvent.class);
                    if (anno == null) continue;
                    for (Class<?> parameter : method.getParameterTypes()) {
                        if (!Event.class.isAssignableFrom(parameter)) continue;
                        map.computeIfAbsent(parameter, aClass -> new ArrayList()).add(new Pair<EventPriority, Method>(anno.priority(), method));
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CommandRuntimeException((Component)Component.m_237113_((String)e.getMessage()));
        }
    }

    private static int eggify(CommandContext<CommandSourceStack> ctx, Entity target) throws CommandRuntimeException, CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        Entity entity = target;
        if (entity == null) {
            player.m_213846_((Component)Component.m_237113_((String)"You must be looking at an entity!"));
            return 1;
        }
        ItemStack spawnEgg = new ItemStack((ItemLike)SpawnEggItem.m_43213_((EntityType)entity.m_6095_()));
        CompoundTag data = entity.serializeNBT();
        spawnEgg.m_41700_("EntityTag", (Tag)data);
        data.m_128473_("Pos");
        data.m_128473_("Motion");
        data.m_128473_("Rotation");
        data.m_128473_("FallDistance");
        data.m_128473_("Fire");
        data.m_128473_("Air");
        data.m_128473_("OnGround");
        data.m_128473_("Dimension");
        data.m_128473_("Invulnerable");
        data.m_128473_("PortalCooldown");
        data.m_128473_("UUID");
        InventoryUtils.givePlayerStack((Player)player, spawnEgg);
        return 0;
    }

    @Nullable
    protected static Entity traceEntity(Player player) {
        Entity entity = null;
        return entity;
    }

    private static Map<UUID, GameProfile> accessiblePlayers(CommandSourceStack source) throws CommandRuntimeException {
        HashMap<UUID, GameProfile> playerMap = new HashMap<UUID, GameProfile>();
        return playerMap;
    }

    private static int playerAccess(CommandSourceStack source, String target) throws CommandRuntimeException, CommandSyntaxException {
        GameProfileCache cache = source.m_81377_().m_129927_();
        Map<UUID, GameProfile> playerMap = BCUtilCommands.accessiblePlayers(source);
        if (target == null) {
            source.m_288197_(() -> Component.m_237113_((String)"################## All Known Players ##################"), false);
            for (UUID uuid : playerMap.keySet()) {
                GameProfile profile = playerMap.get(uuid);
                boolean online = false;
                for (Player player : source.m_81377_().m_6846_().m_11314_()) {
                    if (!player.m_36316_().getId().equals(uuid)) continue;
                    online = true;
                    break;
                }
                MutableComponent message = Component.m_237113_((String)((online ? ChatFormatting.GREEN + "[Online]: " : ChatFormatting.GRAY + "[Offline]: ") + profile.getName()));
                boolean offline = UUID.nameUUIDFromBytes(("OfflinePlayer:" + profile.getName()).getBytes(Charsets.UTF_8)).equals(uuid);
                if (offline) {
                    message.m_7220_((Component)Component.m_237113_((String)" (Offline Account)").m_130940_(ChatFormatting.RED));
                }
                MutableComponent messageHover = Component.m_237113_((String)"Last Seen: \n").m_7220_((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "UUID: " + uuid + "\n"))).m_7220_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "-Click to access player.")));
                Style msgStyle = Style.f_131099_;
                msgStyle.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/bcore_util player_access " + uuid));
                msgStyle.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)messageHover));
                message.m_6270_(msgStyle);
                source.m_288197_(() -> message, false);
            }
            return 0;
        }
        target = target.toLowerCase(Locale.ENGLISH);
        GameProfile profile = null;
        if (cache.m_10996_(target).isPresent()) {
            profile = (GameProfile)cache.m_10996_(target).get();
            target = profile.getId().toString();
        } else {
            try {
                profile = cache.m_11002_(UUID.fromString(target)).orElse(null);
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
            if (profile == null) {
                throw new CommandRuntimeException((Component)Component.m_237113_((String)"Could not find the specified player name or uuid!"));
            }
        }
        ServerPlayer playerSender = source.m_81375_();
        ServerPlayer targetPlayer = source.m_81377_().m_6846_().m_11259_(profile.getId());
        if (targetPlayer == null) {
            File file = BCUtilCommands.getPlayerFile(source.m_81377_(), target);
        }
        if (playerSender == targetPlayer) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"This command only works on other players!"));
        }
        BCUtilCommands.openPlayerAccessUI(source.m_81377_(), playerSender, (Player)targetPlayer);
        return 0;
    }

    public static File getPlayerFile(MinecraftServer server, String uuid) throws CommandRuntimeException {
        throw new CommandRuntimeException((Component)Component.m_237113_((String)"Could not find a data file for the specified player!"));
    }

    public static CompoundTag readPlayerCompound(File playerData) throws CommandRuntimeException {
        CompoundTag compoundTag;
        DataInputStream is = null;
        try {
            is = new DataInputStream(new GZIPInputStream(new FileInputStream(playerData)));
            CompoundTag compound = NbtIo.m_128928_((DataInput)is);
            IOUtils.closeQuietly((InputStream)is);
            compoundTag = compound;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new CommandRuntimeException((Component)Component.m_237113_((String)e.toString()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return compoundTag;
    }

    public static void writePlayerCompound(File playerFile, CompoundTag playerCompound) throws IOException {
        DataOutputStream os = null;
        try {
            os = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(playerFile)));
            NbtIo.m_128941_((CompoundTag)playerCompound, (DataOutput)os);
            IOUtils.closeQuietly((OutputStream)os);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    public static void openPlayerAccessUI(final MinecraftServer server, ServerPlayer player, final Player playerAccess) {
        player.m_9217_();
        player.m_9230_();
        int windowId = player.f_8940_;
        BCoreNetwork.sendOpenPlayerAccessUI(player, windowId);
        BCoreNetwork.sendPlayerAccessUIUpdate(player, playerAccess);
        player.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Player Access");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                ContainerPlayerAccess access = new ContainerPlayerAccess(id, playerInventory, playerAccess, server);
                return access;
            }
        });
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.f_36096_));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerDev1() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"dev1").requires(cs -> cs.m_6761_(3))).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            int radius = 90;
            BlockPos origin = player.m_20183_().m_7918_(0, 88 - player.m_20183_().m_123342_(), 0);
            BlockPos.m_121940_((BlockPos)origin.m_7918_(-radius, -20, -radius), (BlockPos)origin.m_7918_(radius, 20, radius)).forEach(blockPos -> {
                if (Utils.getDistance(blockPos.m_123341_(), blockPos.m_123343_(), origin.m_123341_(), origin.m_123343_()) > (double)radius) {
                    return;
                }
                BlockState state = level.m_8055_(blockPos);
                if (state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_)) {
                    level.m_7471_(blockPos, false);
                }
            });
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerDev2() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"dev2").requires(cs -> cs.m_6761_(3))).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            player.m_213846_((Component)Component.m_237113_((String)"Ligwewht!4dfdsf"));
            return 0;
        });
    }

    private static /* synthetic */ void lambda$functionNBT$39(Player player, String s) {
        ChatHelper.sendMessage(player, (Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.GOLD));
    }
}

