/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.recipe.jei;

import com.cyanogen.experienceobelisk.gui.MolecularMetamorpherMenu;
import com.cyanogen.experienceobelisk.network.shared.UpdateInventory;
import com.cyanogen.experienceobelisk.recipe.MolecularMetamorpherRecipe;
import com.cyanogen.experienceobelisk.recipe.jei.MolecularMetamorpherCategory;
import com.cyanogen.experienceobelisk.registries.RegisterMenus;
import java.util.ArrayList;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class MolecularMetamorpherTransferHandler
implements IRecipeTransferHandler<MolecularMetamorpherMenu, MolecularMetamorpherRecipe> {
    public final IRecipeTransferHandlerHelper helper;

    public MolecularMetamorpherTransferHandler(IRecipeTransferRegistration registration) {
        this.helper = registration.getTransferHelper();
    }

    public Class<? extends MolecularMetamorpherMenu> getContainerClass() {
        return MolecularMetamorpherMenu.class;
    }

    public Optional<MenuType<MolecularMetamorpherMenu>> getMenuType() {
        return Optional.of((MenuType)RegisterMenus.MOLECULAR_METAMORPHER_MENU.get());
    }

    public RecipeType<MolecularMetamorpherRecipe> getRecipeType() {
        return MolecularMetamorpherCategory.METAMORPHER_TYPE;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(MolecularMetamorpherMenu menu, MolecularMetamorpherRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (recipe.isNameFormatting()) {
            return this.helper.createInternalError();
        }
        return this.checkAndTransfer(menu, recipe, recipeSlots, player, maxTransfer, doTransfer);
    }

    public IRecipeTransferError checkAndTransfer(MolecularMetamorpherMenu menu, MolecularMetamorpherRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        ItemStack[] playerItems = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_};
        int[] playerItemCount = new int[]{0, 0, 0};
        int[] requiredCount = new int[]{0, 0, 0};
        IRecipeTransferError error = this.checkOnly(playerItems, playerItemCount, requiredCount, menu, recipe, player, recipeSlots);
        int[] countToTransfer = maxTransfer ? new int[]{Math.min(playerItemCount[0], playerItems[0].m_41741_()), Math.min(playerItemCount[1], playerItems[1].m_41741_()), Math.min(playerItemCount[2], playerItems[2].m_41741_())} : requiredCount;
        if (error == null && doTransfer) {
            return this.transferOnly(playerItems, countToTransfer, menu, player);
        }
        return error;
    }

    public IRecipeTransferError checkOnly(ItemStack[] playerItems, int[] playerItemCount, int[] requiredCount, MolecularMetamorpherMenu menu, MolecularMetamorpherRecipe recipe, Player player, IRecipeSlotsView recipeSlots) {
        int[] spaces = new int[]{-1, -1, -1};
        for (int i = 0; i < 3; ++i) {
            ItemStack menuStack = menu.m_38853_(i).m_7993_();
            if (menuStack.m_41619_()) {
                spaces[i] = 999;
                continue;
            }
            for (int k = 0; k < player.m_150109_().f_35974_.size(); ++k) {
                ItemStack playerStack = player.m_150109_().m_8020_(k);
                if (k == spaces[0] || k == spaces[1] || k == spaces[2]) continue;
                if (ItemStack.m_150942_((ItemStack)menuStack, (ItemStack)playerStack) && menuStack.m_41613_() + playerStack.m_41613_() <= menuStack.m_41741_()) {
                    spaces[i] = k;
                    continue;
                }
                if (!playerStack.m_41619_()) continue;
                spaces[i] = k;
            }
        }
        if (spaces[0] == -1 || spaces[1] == -1 || spaces[2] == -1) {
            return this.helper.createUserErrorWithTooltip((Component)Component.m_237115_((String)"jei.experienceobelisk.error.inventory_full"));
        }
        this.getItemInfo(playerItems, playerItemCount, requiredCount, menu, recipe, player);
        if (playerItemCount[0] >= requiredCount[0] && playerItemCount[1] >= requiredCount[1] && playerItemCount[2] >= requiredCount[2]) {
            return null;
        }
        ArrayList<IRecipeSlotView> slotsList = new ArrayList<IRecipeSlotView>();
        for (int i = 0; i < 3; ++i) {
            int slotNumber = i + 1;
            Optional slot = recipeSlots.findSlotByName("input" + slotNumber);
            if (playerItemCount[i] >= requiredCount[i] || !slot.isPresent()) continue;
            slotsList.add((IRecipeSlotView)slot.get());
        }
        MutableComponent component = Component.m_237115_((String)"jei.experienceobelisk.error.missing_items");
        return this.helper.createUserErrorForMissingSlots((Component)component, slotsList);
    }

    public IRecipeTransferError transferOnly(ItemStack[] playerItems, int[] countToTransfer, MolecularMetamorpherMenu menu, Player player) {
        int i;
        boolean uncleared = false;
        for (i = 0; i < 3; ++i) {
            ItemStack stack = menu.m_38853_(i).m_7993_();
            if (stack.m_41619_() || playerItems[i].m_41619_() || countToTransfer[i] <= 0 || player.m_150109_().m_36054_(stack)) continue;
            uncleared = true;
            break;
        }
        if (uncleared) {
            System.out.println("[Cognition JEI Plugin] Player inventory unexpectedly full");
            return this.helper.createInternalError();
        }
        block1: for (i = 0; i < 3; ++i) {
            ItemStack ingredientStack = playerItems[i];
            if (ingredientStack.m_41619_() || ingredientStack.m_150930_(Items.f_41852_) || countToTransfer[i] <= 0) continue;
            for (int k = 0; k < player.m_150109_().f_35974_.size(); ++k) {
                ItemStack playerStack = player.m_150109_().m_8020_(k);
                if (ItemStack.m_150942_((ItemStack)playerStack, (ItemStack)ingredientStack)) {
                    int n = i;
                    countToTransfer[n] = countToTransfer[n] - menu.put(playerStack, countToTransfer[i]);
                }
                if (countToTransfer[i] <= 0) continue block1;
            }
        }
        UpdateInventory.updateInventoryFromClient(player);
        return null;
    }

    public void getItemInfo(ItemStack[] playerItems, int[] playerItemCount, int[] requiredCount, MolecularMetamorpherMenu menu, MolecularMetamorpherRecipe recipe, Player player) {
        block0: for (int i = 1; i <= 3; ++i) {
            Ingredient ingredient = (Ingredient)recipe.getIngredients(true).get(i).m_14418_();
            int count = (Integer)recipe.getIngredients(true).get(i).m_14419_();
            int position = i - 1;
            requiredCount[position] = count;
            for (ItemStack ingredientStack : ingredient.m_43908_()) {
                playerItemCount[position] = 0;
                for (int j = 0; j < player.m_150109_().f_35974_.size(); ++j) {
                    ItemStack playerStack = player.m_150109_().m_8020_(j);
                    if (!ItemStack.m_150942_((ItemStack)playerStack, (ItemStack)ingredientStack)) continue;
                    playerItems[position] = ingredientStack.m_41777_();
                    int n = position;
                    playerItemCount[n] = playerItemCount[n] + playerStack.m_41613_();
                }
                for (int k = 0; k < 3; ++k) {
                    ItemStack menuStack = menu.m_38853_(k).m_7993_();
                    if (!ItemStack.m_150942_((ItemStack)menuStack, (ItemStack)ingredientStack)) continue;
                    playerItems[position] = ingredientStack.m_41777_();
                    int n = position;
                    playerItemCount[n] = playerItemCount[n] + menuStack.m_41613_();
                }
                if (playerItemCount[position] >= count) continue block0;
            }
        }
    }
}

