/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.recipe.jei;

import com.cyanogen.experienceobelisk.gui.MolecularMetamorpherScreen;
import com.cyanogen.experienceobelisk.recipe.EmptyingRecipe;
import com.cyanogen.experienceobelisk.recipe.FillingRecipe;
import com.cyanogen.experienceobelisk.recipe.InfectingRecipe;
import com.cyanogen.experienceobelisk.recipe.MolecularMetamorpherRecipe;
import com.cyanogen.experienceobelisk.recipe.jei.EmptyingCategory;
import com.cyanogen.experienceobelisk.recipe.jei.FillingCategory;
import com.cyanogen.experienceobelisk.recipe.jei.InfectingCategory;
import com.cyanogen.experienceobelisk.recipe.jei.MolecularMetamorpherCategory;
import com.cyanogen.experienceobelisk.recipe.jei.MolecularMetamorpherTransferHandler;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import com.cyanogen.experienceobelisk.utils.RecipeUtils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class CognitionJeiPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MolecularMetamorpherCategory(registration)});
        registration.addRecipeCategories(new IRecipeCategory[]{new InfectingCategory(registration)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FillingCategory(registration)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EmptyingCategory(registration)});
        super.registerCategories(registration);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        List metamorpherRecipes = manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)MolecularMetamorpherRecipe.Type.INSTANCE);
        List infectingRecipes = manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)InfectingRecipe.Type.INSTANCE);
        List fillingRecipes = manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)FillingRecipe.Type.INSTANCE);
        List emptyingRecipes = manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)EmptyingRecipe.Type.INSTANCE);
        ArrayList<MolecularMetamorpherRecipe> extra = new ArrayList<MolecularMetamorpherRecipe>();
        extra.add(RecipeUtils.getEmptyNameFormattingRecipe());
        registration.addRecipes(MolecularMetamorpherCategory.METAMORPHER_TYPE, metamorpherRecipes);
        registration.addRecipes(MolecularMetamorpherCategory.METAMORPHER_TYPE, extra);
        registration.addRecipes(InfectingCategory.INFECTING_TYPE, infectingRecipes);
        registration.addRecipes(FillingCategory.FILLING_TYPE, fillingRecipes);
        registration.addRecipes(EmptyingCategory.EMPTYING_TYPE, emptyingRecipes);
        System.out.println("[Cognition JEI Plugin]");
        System.out.println("Metamorphosis: Added " + metamorpherRecipes.size() + " recipes");
        System.out.println("Infecting: Added " + infectingRecipes.size() + " recipes");
        System.out.println("Filling: Added " + fillingRecipes.size() + " recipes");
        System.out.println("Emptying: Added " + emptyingRecipes.size() + " recipes");
        ItemStack forgottenDust = new ItemStack((ItemLike)RegisterItems.FORGOTTEN_DUST.get());
        registration.addIngredientInfo((Object)forgottenDust, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.experienceobelisk.description.forgotten_dust")});
        ArrayList<ItemStack> hidden = new ArrayList<ItemStack>();
        hidden.add(((Item)RegisterItems.DUMMY_SWORD.get()).m_7968_());
        registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, hidden);
        super.registerRecipes(registration);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Item)RegisterItems.MOLECULAR_METAMORPHER_ITEM.get()).m_7968_(), new RecipeType[]{MolecularMetamorpherCategory.METAMORPHER_TYPE});
        registration.addRecipeCatalyst(((Item)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get()).m_7968_(), new RecipeType[]{FillingCategory.FILLING_TYPE});
        registration.addRecipeCatalyst(((Item)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get()).m_7968_(), new RecipeType[]{EmptyingCategory.EMPTYING_TYPE});
        for (ItemStack catalyst : RecipeUtils.getCatalysts()) {
            registration.addRecipeCatalyst(catalyst, new RecipeType[]{InfectingCategory.INFECTING_TYPE});
        }
        super.registerRecipeCatalysts(registration);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new MolecularMetamorpherTransferHandler(registration), MolecularMetamorpherCategory.METAMORPHER_TYPE);
        super.registerRecipeTransferHandlers(registration);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(MolecularMetamorpherScreen.class, 107, 45, 32, 10, new RecipeType[]{MolecularMetamorpherCategory.METAMORPHER_TYPE});
        super.registerGuiHandlers(registration);
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("experienceobelisk", "jei_plugin");
    }
}

