/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class EmptyingRecipe
implements Recipe<SimpleContainer> {
    private final Ingredient ingredient;
    private final ItemStack result;
    private final boolean hasResultStack;
    private final int mBgain;
    private final ResourceLocation id;

    public EmptyingRecipe(Ingredient ingredient, ItemStack result, boolean hasResultStack, int mBgain, ResourceLocation id) {
        this.ingredient = ingredient;
        this.result = result;
        this.hasResultStack = hasResultStack;
        this.mBgain = mBgain;
        this.id = id;
    }

    @Nullable
    public static EmptyingRecipe getRecipe(Level level, ItemStack stack) {
        List recipeList = level.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
        EmptyingRecipe infectingRecipe = null;
        for (EmptyingRecipe recipe : recipeList) {
            if (!recipe.matches(stack)) continue;
            infectingRecipe = recipe;
            break;
        }
        return infectingRecipe;
    }

    public boolean matches(ItemStack stack) {
        return this.matches(new SimpleContainer(new ItemStack[]{stack}), null);
    }

    public boolean matches(SimpleContainer container, @Nullable Level level) {
        return this.ingredient.test(container.m_8020_(0));
    }

    public ItemStack assemble(@Nullable SimpleContainer container, @Nullable RegistryAccess access) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public ItemStack m_8043_(@Nullable RegistryAccess access) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean hasResultStack() {
        return this.hasResultStack;
    }

    public int getCognitiumGain() {
        return this.mBgain;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Type
    implements RecipeType<EmptyingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "emptying";
    }

    public static class Serializer
    implements RecipeSerializer<EmptyingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("experienceobelisk", "emptying");

        public EmptyingRecipe fromJson(ResourceLocation id, JsonObject recipe) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)recipe, (String)"ingredient"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)recipe, (String)"result"));
            boolean hasResultStack = GsonHelper.m_13912_((JsonObject)recipe, (String)"hasResultStack");
            int mBgain = GsonHelper.m_13927_((JsonObject)recipe, (String)"gain_mB");
            return new EmptyingRecipe(ingredient, result, hasResultStack, mBgain, id);
        }

        @Nullable
        public EmptyingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            boolean hasResultStack = buffer.readBoolean();
            int mBgain = buffer.readInt();
            return new EmptyingRecipe(ingredient, result, hasResultStack, mBgain, id);
        }

        public void toNetwork(FriendlyByteBuf buffer, EmptyingRecipe recipe) {
            recipe.getIngredient().m_43923_(buffer);
            buffer.writeItemStack(recipe.m_8043_(null), false);
            buffer.writeBoolean(recipe.hasResultStack);
            buffer.writeInt(recipe.mBgain);
        }
    }
}

