/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.item;

import com.cyanogen.experienceobelisk.config.Config;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class CognitiveBowItem
extends BowItem {
    private final float velocityMultiplier;
    private final float accuracyMultiplier;

    public CognitiveBowItem(int maxDamage, float velocityMultiplier, float accuracyMultiplier) {
        super(new Item.Properties().m_41503_(maxDamage));
        this.velocityMultiplier = velocityMultiplier;
        this.accuracyMultiplier = accuracyMultiplier;
    }

    public static void registerProperties() {
        ResourceLocation pulling = new ResourceLocation("experienceobelisk:pulling");
        ResourceLocation pull = new ResourceLocation("experienceobelisk:pull");
        ItemProperties.register((Item)((Item)RegisterItems.COGNITIVE_BOW.get()), (ResourceLocation)pulling, (stack, level, entity, seed) -> CognitiveBowItem.getPull(stack, (Entity)entity, true));
        ItemProperties.register((Item)((Item)RegisterItems.COGNITIVE_BOW.get()), (ResourceLocation)pull, (stack, level, entity, seed) -> CognitiveBowItem.getPull(stack, (Entity)entity, false));
    }

    public static float getPull(ItemStack stack, Entity entity, boolean binary) {
        float pull = 0.0f;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.m_41720_() instanceof CognitiveBowItem && Objects.equals(player.m_21211_(), stack)) {
                pull = binary ? 1.0f : (float)player.m_21252_() / 20.0f;
            }
        }
        return pull;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean flag = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
            ItemStack itemstack = player.m_6298_(stack);
            int i = this.m_8105_(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)i, (!itemstack.m_41619_() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() || flag) {
                if (itemstack.m_41619_()) {
                    itemstack = new ItemStack((ItemLike)Items.f_42412_);
                }
                float f = CognitiveBowItem.m_40661_((int)i);
                float velocity = f * 3.0f * this.velocityMultiplier;
                float inaccuracy = 1.0f / this.accuracyMultiplier;
                if (!((double)f < 0.1)) {
                    boolean flag1;
                    boolean bl = flag1 = player.m_150110_().f_35937_ || itemstack.m_41720_() instanceof ArrowItem && ((ArrowItem)itemstack.m_41720_()).isInfinite(itemstack, stack, player);
                    if (!level.f_46443_) {
                        int k;
                        int j;
                        ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
                        AbstractArrow abstractarrow = arrowitem.m_6394_(level, itemstack, (LivingEntity)player);
                        abstractarrow = this.customArrow(abstractarrow);
                        abstractarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, velocity, inaccuracy);
                        if (f == 1.0f) {
                            abstractarrow.m_36762_(true);
                        }
                        if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
                            abstractarrow.m_36781_(abstractarrow.m_36789_() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                            abstractarrow.m_36735_(k);
                        }
                        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                            abstractarrow.m_20254_(100);
                        }
                        stack.m_41622_(1, (LivingEntity)player, p_289501_ -> p_289501_.m_21190_(player.m_7655_()));
                        if (flag1 || player.m_150110_().f_35937_ && (itemstack.m_150930_(Items.f_42737_) || itemstack.m_150930_(Items.f_42738_))) {
                            abstractarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.m_7967_((Entity)abstractarrow);
                    }
                    level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            player.m_150109_().m_36057_(itemstack);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    public String getPercentageString(float multiplier) {
        return Math.round((multiplier - 1.0f) * 100.0f) + "%";
    }

    public static void handleTooltip(ItemTooltipEvent event) {
        List tooltipList = event.getToolTip();
        Item item = event.getItemStack().m_41720_();
        if (item instanceof CognitiveBowItem) {
            CognitiveBowItem bow = (CognitiveBowItem)item;
            if (((Boolean)Config.COMMON.showAdditionalBowInfo.get()).booleanValue()) {
                ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
                tooltips.add(Component.m_237113_((String)""));
                tooltips.add(Component.m_237115_((String)"tooltip.experienceobelisk.cognitive_bow.firing").m_130940_(ChatFormatting.GRAY));
                tooltips.add(Component.m_237110_((String)"tooltip.experienceobelisk.cognitive_bow.velocity_multiplier", (Object[])new Object[]{Component.m_237113_((String)bow.getPercentageString(bow.velocityMultiplier)).m_130940_(ChatFormatting.BLUE)}));
                tooltips.add(Component.m_237110_((String)"tooltip.experienceobelisk.cognitive_bow.accuracy_multiplier", (Object[])new Object[]{Component.m_237113_((String)bow.getPercentageString(bow.accuracyMultiplier)).m_130940_(ChatFormatting.BLUE)}));
                if (event.getFlags().m_7050_()) {
                    tooltipList.addAll(tooltipList.size() - 2, tooltips);
                } else {
                    tooltipList.addAll(tooltips);
                }
            }
        }
    }
}

