/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.item;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.kenddie.fantasyarmor.config.FAArmorAttributesConfig;
import net.kenddie.fantasyarmor.config.FAArmorConfig;
import net.kenddie.fantasyarmor.item.FAItems;
import net.kenddie.fantasyarmor.item.armor.FAArmorAttributes;
import net.kenddie.fantasyarmor.item.armor.FAArmorSet;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegistryObject;

public final class FAArmorItems {
    public static final Map<FAArmorSet, Map<ArmorItem.Type, RegistryObject<Item>>> ARMOR_ITEMS = new HashMap<FAArmorSet, Map<ArmorItem.Type, RegistryObject<Item>>>();

    public static void register(IEventBus eventBus) {
        for (FAArmorSet set : FAArmorSet.values()) {
            HashMap<ArmorItem.Type, RegistryObject> setPieces = new HashMap<ArmorItem.Type, RegistryObject>();
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                String name = set.getName() + "_" + type.m_266355_();
                FAArmorAttributesConfig config = FAArmorConfig.ARMOR_CONFIGS.get(set.getName()).get(type.m_266355_());
                Supplier<FAArmorAttributes> attributesSupplier = () -> new FAArmorAttributes.Builder().armor((Double)config.armor.get()).armorToughness((Double)config.armorToughness.get()).knockbackResistance((Double)config.knockbackResistance.get()).movementSpeed((Double)config.movementSpeed.get()).maxHealth((Double)config.maxHealth.get()).attackDamage((Double)config.attackDamage.get()).attackSpeed((Double)config.attackSpeed.get()).luck((Double)config.luck.get()).build();
                RegistryObject item = FAItems.ITEMS.register(name, () -> set.create(type, attributesSupplier));
                setPieces.put(type, item);
            }
            ARMOR_ITEMS.put(set, setPieces);
        }
    }

    public static RegistryObject<Item> getArmorItem(FAArmorSet set, ArmorItem.Type type) {
        return ARMOR_ITEMS.get((Object)set).get(type);
    }

    private FAArmorItems() {
    }
}

